package com.elitesland.scp.domain.entity.purLimit;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name = "scp_pur_limit_setting")
@org.hibernate.annotations.Table(appliesTo = "scp_pur_limit_setting", comment = "订货限购表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "订货限购表", description = "订货限购表")
@Where(clause = "delete_flag = 0")
public class ScpPurLimitSettingDO extends BaseModel implements Serializable {

    @ApiModelProperty("活动编码")
    @Comment("活动编码")
    @Column()
    private String activityCode;

    @ApiModelProperty("活动名称")
    @Comment("活动名称")
    @Column()
    private String activityName;

    @ApiModelProperty("活动类型")
    @Comment("活动类型")
    @Column()
    private String activityType;

    @ApiModelProperty("单据类型")
    @Comment("单据类型")
    @Column()
    private String docType;

    @ApiModelProperty(value = "生效日期")
    @Comment("生效时间")
    @Column()
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "失效日期")
    @Comment("失效时间")
    @Column()
    private LocalDateTime validTo;

    @ApiModelProperty("是否启用,0:禁用,1:启用")
    @Comment("是否启用,0:禁用,1:启用")
    @Column()
    private Boolean status;

}
