package com.elitesland.scp.domain.entity.wqf;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;


/**
* @description: 微企付商户账户申请明细
* @author: jeesie.jiang
* @create: 2025-02-27
* @Version 1.0
**/
@Entity
@Table(name = "scp_wqf_ent_account_apply_d")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "scp_wqf_ent_account_apply_d", comment = "微企付商户账户申请明细")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Data
@Accessors(chain = true)
@ApiModel(value = "scp_wqf_ent_account_apply_d", description = "微企付商户账户申请明细")
public class ScpWqfEntAccountApplyDDO extends BaseModel implements Serializable {

    @Column(name = "mas_id", columnDefinition = "bigint")
    @Comment("主表ID")
    private Long masId;

    @Column(name = "line_no", columnDefinition = "int")
    @Comment("行号")
    private Integer lineNo;

    @Column(name = "account_type", columnDefinition = "varchar(64)")
    @Comment("账户类型")
    private String accountType;

    @Column(name = "store_id", columnDefinition = "bigint")
    @Comment("门店ID")
    private Long storeId;

    @Column(name = "store_code", columnDefinition = "varchar(32)")
    @Comment("门店编码")
    private String storeCode;

    @Column(name = "bank_account", columnDefinition = "varchar(64)")
    @Comment("门店充值子账号")
    private String bankAccount;

    @Column(name = "open_bank", columnDefinition = "varchar(500)")
    @Comment("开户银行")
    private String openBank;

    @Column(name = "branch_name", columnDefinition = "varchar(500)")
    @Comment("开户支行名")
    private String branchName;

    @Column(name = "bank_branch_code", columnDefinition = "varchar(256)")
    @Comment("开户联行号")
    private String bankBranchCode;

}