package com.elitesland.scp.domain.service.minOrder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingItemSaveVO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.minOrder.ScpMinOrderSettingItemConvert;
import com.elitesland.scp.domain.entity.minOrder.ScpMinOrderSettingItemDO;
import com.elitesland.scp.domain.entity.minOrder.ScpMinOrderSettingRedisDO;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingItemRepo;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingItemRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;


@Slf4j
@Service
@RequiredArgsConstructor
public class ScpMinOrderSettingItemDomainServiceImpl implements ScpMinOrderSettingItemDomainService {

    private final RedisTemplate redisTemplate;
    private final ScpMinOrderSettingItemRepo scpMinOrderSettingItemRepo;
    private final ScpMinOrderSettingItemRepoProc scpMinOrderSettingItemRepoProc;

    @Override
    @SysCodeProc
    public List<ScpMinOrderSettingItemRespVO> findByMasId(Long masId) {
        List<ScpMinOrderSettingItemDO> settingItemDOS = scpMinOrderSettingItemRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingItemDOS)) {
            return ScpMinOrderSettingItemConvert.INSTANCE.dosToRespVOS(settingItemDOS);
        }
        return new ArrayList<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchSaveMinOrderSettingItem(List<ScpMinOrderSettingItemSaveVO> saveVOS) {
        scpMinOrderSettingItemRepo.saveAll(ScpMinOrderSettingItemConvert.INSTANCE.saveVosDOS(saveVOS));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Long masId) {
        scpMinOrderSettingItemRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(List<Long> ids) {
        scpMinOrderSettingItemRepo.deleteByIds(ids);
    }

    @Override
    public List<ScpMinOrderSettingItemRespVO> getEnableMinOrderSettingItemByStoreCode(String storeCode, List<String> itemTypes) {
        List<ScpMinOrderSettingItemRespVO> respVOS = new ArrayList<>();
        Object obj = redisTemplate.opsForValue().get(ScpConstant.MIN_ORDER_SETTING + storeCode);
        if (obj == null) {
            return new ArrayList<>();
        }
        String str = (String) obj;
        var setting = JSON.parseObject(str, ScpMinOrderSettingRedisDO.class);
        List<ScpMinOrderSettingRedisDO.ActivityDO> activityList = setting.getActivityList();
        for (ScpMinOrderSettingRedisDO.ActivityDO activityDO : activityList) {
            log.info("getEnableMinOrderSettingItemByStoreCode:{}", JSONUtil.toJsonStr(activityDO));
            Object key = redisTemplate.opsForValue().get(ScpConstant.MIN_ORDER_SETTING + activityDO.getActivityId());
            if (key == null) {
                log.info("起订活动ID:{}，缓存不存在", activityDO.getActivityId());
                continue;
            }
            if (LocalDateTime.now().isBefore(activityDO.getValidFrom()) || LocalDateTime.now().isAfter(activityDO.getValidTo())) {
                log.info("起订活动ID:{}，已过期", activityDO.getActivityId());
                continue;
            }
            List<ScpMinOrderSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS = activityDO.getInnerItemDOS();
            for (ScpMinOrderSettingRedisDO.ActivityDO.InnerItemDO innerItemDO : innerItemDOS) {
                ScpMinOrderSettingItemRespVO scpMinOrderSettingItemRespVO = new ScpMinOrderSettingItemRespVO();
                scpMinOrderSettingItemRespVO.setItemId(innerItemDO.getItemId());
                scpMinOrderSettingItemRespVO.setItemCode(innerItemDO.getItemCode());
                scpMinOrderSettingItemRespVO.setItemName(innerItemDO.getItemName());
                scpMinOrderSettingItemRespVO.setMasId(innerItemDO.getMasId());
                scpMinOrderSettingItemRespVO.setMinNum(innerItemDO.getMinNum());
                scpMinOrderSettingItemRespVO.setActivityCode(activityDO.getActivityCode());
                scpMinOrderSettingItemRespVO.setImgUrl(innerItemDO.getImgUrl());
                respVOS.add(scpMinOrderSettingItemRespVO);
            }
        }
        log.info("getEnableMinOrderSettingItemByStoreCode:{}", JSONUtil.toJsonStr(respVOS));
        return respVOS;
    }

    @Override
    public List<Long> findMasIdByItemId(Long itemId) {
        return scpMinOrderSettingItemRepoProc.findMasIdByItemId(itemId);
    }
}
