package com.elitesland.scp.infr.dto.order;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel("订货订单详情返回")
public class ScpDemandOrderDTO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = 1876265003012917216L;

    @ApiModelProperty("订货集ID")
    private Long demandId;

    @ApiModelProperty("订货集编码")
    private String demandCode;

    @ApiModelProperty("订货集名称")
    private String demandName;

    @ApiModelProperty("订货单编码")
    private String docCode;

    @ApiModelProperty("单据类别")
    @SysCode(sys = "yst-suplan", mod = "OB_DOC_CLS")
    private String docCls;
    private String docClsName;

    @ApiModelProperty("业务类型")
    @SysCode(sys = "yst-suplan", mod = "BUSINESS_TYPE")
    private String businessType;
    private String businessTypeName;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-suplan", mod = "DEO_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("单据类型")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("付款状态")
    private String payStatus;
    private String payStatusName;

    @ApiModelProperty("类型")
    @SysCode(sys = "yst-suplan", mod = "DEMAND_SET_TYPE")
    private String type;
    private String typeName;

    @ApiModelProperty("需求仓库id/门店id")
    private Long demandWhStId;

    @ApiModelProperty("需求仓库编码/门店编码")
    private String demandWhStCode;

    @ApiModelProperty("需求仓库名称/门店名称")
    private String demandWhStName;

    @ApiModelProperty("需求日期")
    private LocalDateTime demandDate;

    @ApiModelProperty("经营性质")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE2")
    private String storeType2;
    private String storeType2Name;

    @ApiModelProperty("店面等级")
    private String storeLevel;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("收货地址号")
    private Long recvAddrNo;

    @ApiModelProperty("收货联系人")
    private String recvContactName;

    @ApiModelProperty("收货联系电话")
    private String recvContactTel;

    @ApiModelProperty("收货国家")
    private String recvCountry;

    @ApiModelProperty("收货省")
    private String recvProvince;

    @ApiModelProperty("收货市")
    private String recvCity;

    @ApiModelProperty("收货区县")
    private String recvCounty;

    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;

    @ApiModelProperty("装修门店")
    private String renovationStore;

    @ApiModelProperty(value = "在线账户支付金额")
    private BigDecimal creditAccAmt;

    @ApiModelProperty(value = "补贴账户支付金额")
    private BigDecimal flzhAccAmt;

    @ApiModelProperty(value = "储值账户支付金额")
    private BigDecimal storeAccAmt;

    @ApiModelProperty("是否已推送, true:是，false:是")
    private Boolean isPushed;

    @ApiModelProperty(value = "全部推送时间")
    private LocalDateTime pushedTime;

    @ApiModelProperty("订单取消操作人")
    private String cancelOperator;

    /**
     * 工作流字段
     */
    @ApiModelProperty("审批状态")
    @SysCode(sys = "yst-suplan", mod = "DEO_APPR_STATUS")
    private String apprStatus;
    private String apprStatusName;

    @ApiModelProperty("流程实例ID")
    @Column
    @Comment("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    @Column
    @Comment("流程实例状态")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @ApiModelProperty(value = "提交时间")
    @Comment("提交时间")
    @Column
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    @Comment("审批通过时间")
    @Column
    private LocalDateTime approvedTime;


    @ApiModelProperty("预计到货日期")
    private LocalDateTime etaDate;
}
