package com.elitesland.scp.infr.repo.scpsman;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpsmanRegionPageQueryParam;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanRegionVO;
import com.elitesland.scp.domain.bo.ScpsmanRegionBO;
import com.elitesland.scp.domain.entity.scpsman.QScpsmanRegionDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanRegionDO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/6 周六
 */
@Repository
public class ScpsmanRegionRepoProc extends BaseRepoProc<ScpsmanRegionDO> {
    private static final QScpsmanRegionDO QDO = QScpsmanRegionDO.scpsmanRegionDO;

    public ScpsmanRegionRepoProc() {
        super(QDO);
    }

    public List<String> getRegionCodesByMasId(long masId, String regionType) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.masId, masId)
                .andEq(QDO.regionType, regionType)
                .build();
        return super.getValueList(QDO.regionCode, predicate);
    }

    public List<ScpsmanRegionBO> listBoByMasId(long masId) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.masId, masId)
                .build();
        return super.getList(qbeanBO(), predicate);
    }

    public List<ScpsmanRegionDO> listByMasId(long masId) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.masId, masId)
                .build();
        return super.getList(predicate);
    }

    public void deleteByMasId(long masId, String regionType) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.masId, masId)
                .andEq(QDO.regionType, regionType)
                .build();
        super.delete(predicate);
    }

    public void delete(long masId, String regionType, Collection<String> regionCode) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.masId, masId)
                .andEq(QDO.regionType, regionType)
                .and(QDO.regionCode.in(regionCode))
                .build();
        super.delete(predicate);
    }

    public PagingVO<SalesmanRegionVO> pageQuery(ScpsmanRegionPageQueryParam queryParam, Collection<String> regionCodes) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.masId, queryParam.getScpsmanId())
                .andEq(QDO.regionType, queryParam.getRegionType())
                .andLike(QDO.regionCode, queryParam.getRegionCode())
                .andIn(QDO.regionCode, regionCodes)
                .build();
        return super.queryByPage(qbeanVO(), predicate, queryParam.getPageRequest(), QDO.createTime.desc());
    }

    private QBean<SalesmanRegionVO> qbeanVO() {
        return Projections.bean(SalesmanRegionVO.class,
                QDO.id,
                QDO.masId,
                QDO.regionId,
                QDO.regionType,
                QDO.regionCode,
                QDO.createTime
        );
    }

    private QBean<ScpsmanRegionBO> qbeanBO() {
        return Projections.bean(ScpsmanRegionBO.class,
                QDO.regionType,
                QDO.regionCode
        );
    }
}
