package com.elitesland.scp.provider;

import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigRespVO;
import com.elitesland.scp.application.service.serviceconfig.ScpServiceConfigService;
import com.elitesland.scp.domain.convert.serviceconifg.ScpServiceConfigConvert;
import com.elitesland.scp.dto.ScpServiceConfigParamRpcParam;
import com.elitesland.scp.dto.ScpServiceConfigRpcDTO;
import com.elitesland.scp.service.ScpServiceConfigRpcService;
import com.elitesland.scp.service.order.ScpDemandOrderRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 07月 03日 17:58
 * @version: 1.0
 */
@Slf4j
@Service
@RestController
@RequiredArgsConstructor
@RequestMapping(ScpApplication.URI_PREFIX + ScpServiceConfigRpcService.PATH)
public class ScpServiceConfigRpcServiceImpl implements ScpServiceConfigRpcService {

    private final ScpServiceConfigService scpServiceConfigService;
    @Override
    public Map<String, ScpServiceConfigRpcDTO> findServiceConfigGroupByStore(ScpServiceConfigParamRpcParam paramVO) {
        log.info("查询门店服务配置，参数: {}", paramVO);
        try {
            // 获取原始数据
            Map<String, ScpServiceConfigRespVO> serviceConfigMap = scpServiceConfigService.findServiceConfigGroupByStore(
                    paramVO.getStoreCode(),
                    paramVO.getRegionCode(),
                    paramVO.getLevel()
            );

            if (serviceConfigMap == null || serviceConfigMap.isEmpty()) {
                return Collections.emptyMap();
            }
            return serviceConfigMap.entrySet().stream()
                    .collect(Collectors.toMap(
                            Map.Entry::getKey,
                            entry -> ScpServiceConfigConvert.INSTANCE.respVoToRpcDto(entry.getValue())
                    ));

        } catch (Exception e) {
            log.error("查询门店服务配置失败，参数: {}", paramVO, e);
            return Collections.emptyMap();
        }
    }




}
