/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.alloc;

import cn.hutool.json.JSONUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingImportStoreParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStatusParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStoreChangeParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStoreRefreshParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingRespVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingSaveVO;
import com.elitesland.scp.application.service.alloc.ScpAllocSettingService;
import com.elitesland.scp.utils.excel.listener.DchExcelEntityDataListener;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u8ba2\u8d27\u5f3a\u914d\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/alloc/setting"}, produces={"application/json"})
public class ScpAllocSettingController {
    private static final Logger log = LoggerFactory.getLogger(ScpAllocSettingController.class);
    private final ScpAllocSettingService scpAllocSettingService;

    @ApiOperation(value="\u8ba2\u8d27\u5f3a\u914d-  \u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<ScpAllocSettingPageRespVO>> queryAllocSetting(@RequestBody ScpAllocSettingPageParamVO paramVO) {
        log.info("[SCP-ALLOC-SETTING] queryAllocSetting  param ={}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok(this.scpAllocSettingService.page(paramVO));
    }

    @ApiOperation(value="\u8ba2\u8d27\u5f3a\u914d - \u6839\u636eID\u67e5\u8be2\u8ba2\u8d27\u5f3a\u914d\u6d3b\u52a8\u4fe1\u606f")
    @GetMapping(value={"/findIdOne/{id}"})
    public ApiResult<ScpAllocSettingRespVO> findIdOne(@PathVariable Long id) {
        log.info("[SCP-ALLOC-SETTING] findIdOne, id ={}", (Object)id);
        return ApiResult.ok((Object)this.scpAllocSettingService.findAllocSettingById(id));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u8ba2\u8d27\u5f3a\u914d - \u4fdd\u5b58")
    public ApiResult<Long> saveAllocSetting(@RequestBody @Validated ScpAllocSettingSaveVO saveVO) {
        log.info("[SCP-ALLOC-SETTING] saveAllocSetting  saveVO ={}", (Object)JSONUtil.toJsonStr((Object)saveVO));
        return ApiResult.ok((Object)this.scpAllocSettingService.saveAllocSetting(saveVO));
    }

    @ApiOperation(value="\u8ba2\u8d27\u5f3a\u914d - \u542f\u7528/\u7981\u7528")
    @PostMapping(value={"/change"})
    public ApiResult<Object> changeStatus(@RequestBody @Validated ScpAllocSettingStatusParamVO paramVO) {
        log.info("[SCP-ALLOC-SETTING] changeStatus paramVO = {}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        this.scpAllocSettingService.changeAllocSettingStatus(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u8ba2\u8d27\u5f3a\u914d\u95e8\u5e97\u66f4\u65b0\u6700\u5927\u5f3a\u914d\u6b21\u6570")
    @PostMapping(value={"/storeChangeMaxNum"})
    public ApiResult<Object> storeChangeMaxNum(@RequestBody @Validated List<ScpAllocSettingStoreChangeParamVO> paramVO) {
        log.info("[SCP-ALLOC-SETTING] storeChangeMaxNum paramVO = {}", (Object)JSONUtil.toJsonStr(paramVO));
        this.scpAllocSettingService.storeChangeMaxNum(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u8ba2\u8d27\u5f3a\u914d\u95e8\u5e97\u5237\u65b0")
    @PostMapping(value={"/storeRefresh"})
    public ApiResult<Object> storeRefresh(@RequestBody @Validated ScpAllocSettingStoreRefreshParamVO paramVO) {
        log.info("[SCP-ALLOC-SETTING] storeRefresh paramVO = {}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        this.scpAllocSettingService.storeRefresh(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u8ba2\u8d27\u5f3a\u914d - \u5220\u9664")
    @PostMapping(value={"/delete"})
    public ApiResult<Object> delete(@RequestBody List<Long> ids) {
        log.info("[SCP-ALLOC-SETTING] delete ids = {}", (Object)JSONUtil.toJsonStr(ids));
        this.scpAllocSettingService.deleteByIds(ids);
        return ApiResult.ok();
    }

    @PostMapping(value={"/imports/store"})
    @ApiOperation(value="\u660e\u7ec6\u95e8\u5e97\u5bfc\u5165")
    public ApiResult<List<ScpAllocSettingStoreRespVO>> importStoreData(MultipartFile file) throws InterruptedException {
        DchExcelEntityDataListener dataListener = new DchExcelEntityDataListener();
        try {
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), ScpAllocSettingImportStoreParamVO.class, dataListener).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(2))).doRead();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ApiResult.fail((String)"\u89e3\u6790excel\u6570\u636e\u51fa\u73b0\u5f02\u5e38");
        }
        List<ScpAllocSettingImportStoreParamVO> list = dataListener.getDatas();
        return ApiResult.ok(this.scpAllocSettingService.importStoreData(list));
    }

    @ApiOperation(value="\u8ba2\u8d27\u8ba2\u5355 - \u6839\u636e\u7269\u6599\u7f16\u7801\u5bfc\u51faExcel")
    @GetMapping(value={"/export/item/{itemCode}"})
    public void exportByItemCode(@PathVariable String itemCode, HttpServletResponse response) {
        log.info("[SCP-DEMAND-ORDER] exportByItemCode itemCode = {}", (Object)itemCode);
        this.scpAllocSettingService.exportByItemCode(itemCode, response);
    }

    public ScpAllocSettingController(ScpAllocSettingService scpAllocSettingService) {
        this.scpAllocSettingService = scpAllocSettingService;
    }
}

