/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.minOrder;

import cn.hutool.json.JSONUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingImportStoreParamVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingStatusParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingSaveVO;
import com.elitesland.scp.application.service.minOrder.ScpMinOrderSettingService;
import com.elitesland.scp.utils.excel.listener.DchExcelEntityDataListener;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u8ba2\u8d27\u8d77\u8ba2\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/minOrder/setting"}, produces={"application/json"})
public class ScpMinOrderSettingController {
    private static final Logger log = LoggerFactory.getLogger(ScpMinOrderSettingController.class);
    private final ScpMinOrderSettingService scpMinOrderSettingService;

    @ApiOperation(value="\u8d77\u8ba2\u6d3b\u52a8-\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<ScpMinOrderSettingPageRespVO>> queryMinOrderSetting(@RequestBody ScpMinOrderSettingPageParamVO paramVO) {
        log.info("[SCP-MinOrder-SETTING] queryMinOrderSetting  param ={}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok(this.scpMinOrderSettingService.page(paramVO));
    }

    @ApiOperation(value="\u8d77\u8ba2\u6d3b\u52a8 - \u6839\u636eID\u67e5\u8be2\u8d77\u8ba2\u6d3b\u52a8\u4fe1\u606f")
    @GetMapping(value={"/findIdOne/{id}"})
    public ApiResult<ScpMinOrderSettingRespVO> findIdOne(@PathVariable Long id) {
        log.info("[SCP-MinOrder-SETTING] findIdOne, id ={}", (Object)id);
        return ApiResult.ok((Object)this.scpMinOrderSettingService.findMinOrderSettingById(id));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u8d77\u8ba2\u6d3b\u52a8 - \u4fdd\u5b58")
    public ApiResult<Long> saveMinOrderSetting(@RequestBody @Validated ScpMinOrderSettingSaveVO saveVO) {
        log.info("[SCP-MinOrder-SETTING] saveMinOrderSetting  saveVO ={}", (Object)JSONUtil.toJsonStr((Object)saveVO));
        return ApiResult.ok((Object)this.scpMinOrderSettingService.saveMinOrderSetting(saveVO));
    }

    @ApiOperation(value="\u8d77\u8ba2\u6d3b\u52a8 - \u542f\u7528/\u7981\u7528")
    @PostMapping(value={"/change"})
    public ApiResult<Object> changeStatus(@RequestBody @Validated ScpMinOrderSettingStatusParamVO paramVO) {
        log.info("[SCP-MinOrder-SETTING] changeStatus paramVO = {}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        this.scpMinOrderSettingService.changeMinOrderSettingStatus(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u8d77\u8ba2\u6d3b\u52a8 - \u5220\u9664")
    @PostMapping(value={"/delete"})
    public ApiResult<Object> delete(@RequestBody List<Long> ids) {
        log.info("[SCP-MinOrder-SETTING] delete ids = {}", (Object)JSONUtil.toJsonStr(ids));
        this.scpMinOrderSettingService.deleteByIds(ids);
        return ApiResult.ok();
    }

    @PostMapping(value={"/imports/store"})
    @ApiOperation(value="\u660e\u7ec6\u95e8\u5e97\u5bfc\u5165")
    public ApiResult<List<ScpMinOrderSettingStoreRespVO>> importStoreData(MultipartFile file) throws InterruptedException {
        DchExcelEntityDataListener dataListener = new DchExcelEntityDataListener();
        try {
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), ScpMinOrderSettingImportStoreParamVO.class, dataListener).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(2))).doRead();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ApiResult.fail((String)"\u89e3\u6790excel\u6570\u636e\u51fa\u73b0\u5f02\u5e38");
        }
        List<ScpMinOrderSettingImportStoreParamVO> list = dataListener.getDatas();
        return ApiResult.ok(this.scpMinOrderSettingService.importStoreData(list));
    }

    public ScpMinOrderSettingController(ScpMinOrderSettingService scpMinOrderSettingService) {
        this.scpMinOrderSettingService = scpMinOrderSettingService;
    }
}

