/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.survey;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.scp.domain.entity.survey.QSurveyDO;
import com.elitesland.scp.domain.entity.survey.QSurveyPublishDO;
import com.elitesland.scp.domain.entity.survey.SurveyDO;
import com.elitesland.scp.domain.vo.survey.SurveyPagingParam;
import com.elitesland.scp.domain.vo.survey.SurveyPublishRespVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class SurveyPublishRepoProc
extends BaseRepoProc<SurveyDO> {
    private static final QSurveyDO surveyDO = QSurveyDO.surveyDO;
    private static final QSurveyPublishDO surveyPublishDO = QSurveyPublishDO.surveyPublishDO;

    protected SurveyPublishRepoProc() {
        super((EntityPathBase)surveyDO);
    }

    public List<SurveyPublishRespVO> findPublish(SurveyPagingParam queryVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SurveyPublishRespVO.class, (Expression[])new Expression[]{SurveyPublishRepoProc.surveyPublishDO.id, SurveyPublishRepoProc.surveyPublishDO.ouId, SurveyPublishRepoProc.surveyPublishDO.ouCode, SurveyPublishRepoProc.surveyPublishDO.ouName, SurveyPublishRepoProc.surveyPublishDO.suvId, SurveyPublishRepoProc.surveyPublishDO.fillStatus, SurveyPublishRepoProc.surveyDO.surveyTitle})).from((EntityPath)surveyPublishDO)).leftJoin((EntityPath)surveyDO)).on((Predicate)SurveyPublishRepoProc.surveyDO.id.eq(SurveyPublishRepoProc.surveyPublishDO.suvId))).where(this.where(queryVO));
        return jpaQuery.fetch();
    }

    private Predicate where(SurveyPagingParam param) {
        BooleanExpression predicate = Expressions.ONE.eq((Expression)Expressions.ONE);
        if (StringUtils.isNotEmpty((String)param.getSurveyTitle())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyPublishRepoProc.surveyDO.surveyTitle.like("%" + param.getSurveyTitle() + "%"));
        }
        if (StringUtils.isNotEmpty((String)param.getSurveyStatus())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyPublishRepoProc.surveyDO.surveyStatus.eq((Object)param.getSurveyStatus()));
        }
        if (StringUtils.isNotEmpty((String)param.getPublisherName())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyPublishRepoProc.surveyDO.publisherName.like("%" + param.getPublisherName() + "%"));
        }
        if (param.getCreateTimeFrom() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyPublishRepoProc.surveyDO.createTime.goe((Comparable)param.getCreateTimeFrom()).or((Predicate)SurveyPublishRepoProc.surveyDO.createTime.eq((Object)param.getCreateTimeFrom())));
        }
        if (param.getCreateTimeTo() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyPublishRepoProc.surveyDO.createTime.loe((Comparable)param.getCreateTimeTo()).or((Predicate)SurveyPublishRepoProc.surveyDO.createTime.eq((Object)param.getCreateTimeTo())));
        }
        if (StringUtils.isNotEmpty((String)param.getNeedFilterValidTime()) && "Y".equals(param.getNeedFilterValidTime())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyPublishRepoProc.surveyDO.beginTime.loe((Comparable)LocalDateTime.now()).and((Predicate)SurveyPublishRepoProc.surveyDO.endTime.goe((Comparable)LocalDateTime.now())));
        }
        if (StringUtils.isNotEmpty((String)param.getOuCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyPublishRepoProc.surveyPublishDO.ouCode.eq((Object)param.getOuCode()));
        }
        if (CollectionUtils.isNotEmpty(param.getOuCodeList())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyPublishRepoProc.surveyPublishDO.ouCode.in(param.getOuCodeList()));
        }
        if (param.getRequired() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyPublishRepoProc.surveyDO.required.eq(param.getRequired()));
        }
        if (param.getNotSuvId() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyPublishRepoProc.surveyDO.id.ne((Object)param.getNotSuvId()));
        }
        if (CollectionUtils.isNotEmpty(param.getSuvIdList())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SurveyPublishRepoProc.surveyDO.id.in(param.getSuvIdList()));
        }
        return predicate;
    }
}

