package com.elitesland.scp.application.web;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.service.authority.StoreAuthorityRpcServiceImpl;
import com.elitesland.scp.dto.authority.ItemObject;
import com.elitesland.scp.dto.authority.StoreAuthorityRespDTO;
import com.elitesland.scp.dto.authority.StoreAuthorityRpcDTO;
import com.elitesland.scp.dto.authority.StoreAuthorityRpcPageDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Auther: Mark
 * @Date: 2024/3/27 15:08
 * @Description:
 */
@RestController
@RequestMapping(value = "/authority", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "获取门店要货权限数据", tags = {"获取门店要货权限公共服务接口"})
public class AuthorityController extends BaseController {

    @Autowired
    private StoreAuthorityRpcServiceImpl storeAuthorityRpcServiceImpl;

    @PostMapping(value = "/getStoreAuthorityData")
    @ApiOperation(value = "获取门店要货权限数据")
    public ApiResult<StoreAuthorityRespDTO> getStoreAuthorityData(@RequestBody @Validated StoreAuthorityRpcDTO storeAuthorityRpcDTO) {
        return storeAuthorityRpcServiceImpl.getStoreAuthorityData(storeAuthorityRpcDTO);
    }

    @PostMapping(value = "/getStoreAuthorityDataPage")
    @ApiOperation(value = "获取门店要货权限数据-分页")
    public ApiResult<PagingVO<ItemObject>> getStoreAuthorityDataPage(@RequestBody @Validated StoreAuthorityRpcPageDTO storeAuthorityRpcPageDTO) {
        return storeAuthorityRpcServiceImpl.getStoreAuthorityDataPage(storeAuthorityRpcPageDTO);
    }
}
