package com.elitesland.scp.application.facade.vo.boh;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel(value = "StoreRtnApplyParam", description = "门店退货申请参数")
public class StoreRtnApplyParam implements Serializable {

    private static final long serialVersionUID = -3542365886389320346L;

    @ApiModelProperty("业务单据id")
    private Long docId;

    @ApiModelProperty("发起退货时传入，退货确认时为空")
    private String note;

    @ApiModelProperty(value = "退货图片")
    private List<String> picList;

    @ApiModelProperty("配送方式")
    private String deliveryMethod;

    @ApiModelProperty("明细")
    private List<StoreRtnApplyDetail> details;

    @Data
    public static class StoreRtnApplyDetail implements Serializable {
        private static final long serialVersionUID = -8342040474280563355L;

        @ApiModelProperty("明细id")
        private Long id;

        @ApiModelProperty("实收数量")
        private BigDecimal qty;

        @ApiModelProperty("含税单价")
        private BigDecimal price;
    }
}
