package com.elitesland.scp.application.facade.vo.cart;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/3/26 17:39
 * @Description:
 */
@Data
@ApiModel("下单数据准备结果")
public class PrepareDataBeforeSubmitRespVO implements Serializable {

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    String itemName;

    @ApiModelProperty("单位")
    String uom;

    @ApiModelProperty("单位名称")
    String uomName;

    List<ItemSpecObjectVO> itemSpecObjectVOS;

    @Data
    public static class ItemSpecObjectVO {

        @ApiModelProperty("商品规格")
        String itemSpec;

        @ApiModelProperty("数量")
        BigDecimal qty;

        @ApiModelProperty("仓库名称")
        String whName;

        @ApiModelProperty("含税单价")
        BigDecimal itemPrice;
    }
}
