package com.elitesland.scp.application.facade.vo.freight;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @description: 门店订单运费导导入
 * @author: Rikyon
 * @date: 2025/8/19 9:48
 * @version 1.0
 */
@Data
@ApiModel(value = "ScpStoreOrderFreightImportVO", description = "门店订单运费导入")
public class ScpStoreOrderFreightImportVO implements Serializable {

    @ApiModelProperty(value = "订货类型")
    private String orderTypeName;

    @ApiModelProperty(value = "运费收取方式")
    private String freightMethodName;

    @ApiModelProperty(value = "供应仓库编码")
    private String supplyWhCode;

    @ApiModelProperty(value = "需求门店编码")
    private String demandWhStCode;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "运费收取比例")
    private String freightRate;

    @ApiModelProperty(value = "按数量收取金额")
    private String amountPerQuantity;
}
