package com.elitesland.scp.application.facade.vo.resp.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel("支付订单详情明细")
public class AppPayOrderItemRespVO implements Serializable {
    private static final long serialVersionUID = -2476749156964062758L;

    @ApiModelProperty("种类数量")
    private Integer cateNum;

    @ApiModelProperty("合集数量")
    private BigDecimal totalNum;

    @ApiModelProperty("待支付金额")
    private BigDecimal amt;

    @ApiModelProperty("商品金额合计")
    private BigDecimal goodAmt;

    @ApiModelProperty("运费合计")
    private BigDecimal freightAmt;

    @ApiModelProperty("明细")
    private List<ItemSpecObjectVO> itemList;

    @Data
    public static class ItemSpecObjectVO {

        @ApiModelProperty("商品编码")
        private String itemCode;

        @ApiModelProperty("商品名称")
        private String itemName;

        @ApiModelProperty("明细金额")
        private BigDecimal amt;

        @ApiModelProperty("数量")
        private BigDecimal qty;

        @ApiModelProperty("订货单位")
        private String uom;

        @ApiModelProperty("订货单位名称")
        private String uomName;

        @ApiModelProperty("别名")
        private String anotherName;

        @ApiModelProperty("箱规")
        private String itemAttrName;

        @ApiModelProperty("图片")
        private String url;

        @ApiModelProperty("子件明细")
        private List<ItemSpecObjectVO> itemList;
    }
}
