package com.elitesland.scp.domain.entity.feedback;

import com.el.coordinator.core.common.jpa.entiry.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

@Entity
@Table(name = "scp_store_feedback")
@org.hibernate.annotations.Table(appliesTo = "scp_store_feedback", comment = "门店反馈")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "门店反馈", description = "门店反馈")
@Where(clause = "delete_flag = 0")
public class ScpStoreFeedbackDO extends BaseModel implements Serializable {

    @ApiModelProperty("反馈类型")
    @Comment("反馈类型")
    @Column(name = "feedback_type", columnDefinition = "varchar(50) comment '反馈类型'")
    private String feedbackType;

    @ApiModelProperty("反馈原因")
    @Comment("反馈原因")
    @Column(name = "feedback_reason", columnDefinition = "varchar(255) comment '反馈原因'")
    private String feedbackReason;

    @ApiModelProperty("反馈门店编码")
    @Comment("反馈门店编码")
    @Column(name = "feedback_store_code", columnDefinition = "varchar(50) comment '反馈门店编码'")
    private String feedbackStoreCode;

    @ApiModelProperty("反馈门店名称")
    @Comment("反馈门店名称")
    @Column(name = "feedback_store_name", columnDefinition = "varchar(100) comment '反馈门店名称'")
    private String feedbackStoreName;

    @ApiModelProperty("反馈状态")
    @Comment("反馈状态")
    @Column(name = "feedback_status", columnDefinition = "varchar(50) comment '反馈状态'")
    private String feedbackStatus;

    @ApiModelProperty("商品编码")
    @Comment("商品编码")
    @Column(name = "item_code", columnDefinition = "varchar(50) comment '商品编码'")
    private String itemCode;

    @ApiModelProperty("商品名称")
    @Comment("商品名称")
    @Column(name = "item_name", columnDefinition = "varchar(100) comment '商品名称'")
    private String itemName;

    @ApiModelProperty("反馈评分")
    @Comment("反馈评分")
    @Column(name = "feedback_score", columnDefinition = "decimal(3,1) comment '反馈评分'")
    private BigDecimal feedbackScore;

    @ApiModelProperty("评价意见")
    @Comment("评价意见")
    @Column(name = "evaluation_comment", columnDefinition = "text comment '评价意见'")
    private String evaluationComment;

    @ApiModelProperty("优化意见")
    @Comment("优化意见")
    @Column(name = "optimization_suggestion", columnDefinition = "text comment '优化意见'")
    private String optimizationSuggestion;

    @ApiModelProperty("图片编码")
    @Comment("图片编码")
    @Column(name = "file_code", columnDefinition = "varchar(255) comment '图片编码'")
    private String fileCode;

    @ApiModelProperty("图片url")
    @Comment("图片url")
    @Column(name = "file_url", columnDefinition = "text comment '图片url'")
    private String fileUrl;

    @ApiModelProperty("审批状态")
    @Comment("审批状态")
    @Column(name = "approval_status", columnDefinition = "varchar(20) comment '审批状态'")
    private String approvalStatus;

    @ApiModelProperty("反馈时间")
    @Comment("反馈时间")
    @Column(name = "feedback_time", columnDefinition = "datetime comment '反馈时间'")
    private LocalDateTime feedbackTime;

    @ApiModelProperty("反馈人")
    @Comment("反馈人")
    @Column(name = "feedback_by", columnDefinition = "varchar(50) comment '反馈人'")
    private String feedbackBy;

    @ApiModelProperty("物料分类")
    @Comment("物料分类")
    @Column(name = "item_type2", columnDefinition = "varchar(50) comment '物料分类'")
    private String itemType2;

    @ApiModelProperty("审批人")
    @Comment("审批人")
    @Column(name = "approved_by", columnDefinition = "varchar(50) comment '审批人'")
    private String approvedBy;

    @ApiModelProperty("审批时间")
    @Comment("审批时间")
    @Column(name = "approval_time", columnDefinition = "datetime comment '审批时间'")
    private LocalDateTime approvalTime;

    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    @Column
    @com.elitescloud.cloudt.common.annotation.Comment("流程实例ID")
    String procInstId;

    @ApiModelProperty("流程实例状态")
    @Column
    @com.elitescloud.cloudt.common.annotation.Comment("流程实例状态")
    @Enumerated(EnumType.STRING)
    ProcInstStatus procInstStatus;

    @ApiModelProperty(value = "提交时间")
    @com.elitescloud.cloudt.common.annotation.Comment("提交时间")
    @Column
    LocalDateTime submitTime;
}
