package com.elitesland.scp.domain.service.authority;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.org.service.OrgRegionRpcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/9/4
 */
@Component
public class ScpDemandAuthorityManager {

    @Autowired
    private OrgRegionRpcService orgRegionRpcService;
    @Autowired
    private UdcProvider udcProvider;

    /**
     * 转换区域名称
     *
     * @param dataList      数据列表
     * @param useUdc        是否使用UDC
     * @param getRegionCode 获取区域编码的方法
     * @param setRegionName 设置UDC值的方法
     * @param <T>           数据类型
     */
    public <T> void convertRegionName(List<T> dataList, Predicate<T> useUdc, Function<T, String> getRegionCode,
                                      BiConsumer<T, String> setRegionName) {
        if (CollUtil.isEmpty(dataList)) {
            return;
        }

        // 门店的区域翻译
        Set<String> regionCodes = new HashSet<>(dataList.size());
        Set<String> udcRegionCodes = new HashSet<>(dataList.size());
        for (T t : dataList) {
            // 获取区域编码
            var regionCode = getRegionCode.apply(t);
            if (CharSequenceUtil.isBlank(regionCode)) {
                continue;
            }

            // 是否UDC
            if (useUdc.test(t)) {
                udcRegionCodes.add(regionCode);
                continue;
            }

            regionCodes.add(regionCode);
        }
        if (regionCodes.isEmpty() && udcRegionCodes.isEmpty()) {
            return;
        }

        // 区域主数据
        Map<String, String> regionNameMap = regionCodes.isEmpty() ? Collections.emptyMap() : orgRegionRpcService.getNameByCode(regionCodes).computeData();
        // 区域UDC
        Map<String, String> udcRegionMap = udcRegionCodes.isEmpty() ? Collections.emptyMap() : udcProvider.getValueMapByUdcCode(Application.NAME, "REGION");

        // 设置区域名称
        for (T t : dataList) {
            // 获取区域编码
            var regionCode = getRegionCode.apply(t);
            if (CharSequenceUtil.isBlank(regionCode)) {
                continue;
            }

            String regionName = useUdc.test(t) ? udcRegionMap.get(regionCode) : regionNameMap.get(regionCode);
            setRegionName.accept(t, regionName);
        }
    }
}
