package com.elitesland.scp.lakalapay.service;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderUpdatePayStatusMqParam;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountRepoProc;
import com.elitesland.scp.lakalapay.utils.TcslPay;
import com.elitesland.scp.lakalapay.vo.*;
import com.elitesland.scp.pay.config.EntpayProperties;
import com.elitesland.scp.pay.service.AccountLinkService;
import com.elitesland.scp.pay.service.NotifyVerifyService;
import com.elitesland.scp.pay.vo.PayOrderReqDTO;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiPurRpcService;
import com.elitesland.scp.utils.MessageDelyQueueService;
import com.elitesland.support.provider.org.dto.OrgBankRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuBankRpcDTO;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.tenpay.business.entpay.mse.sdk.common.NotifyHandler;
import com.tenpay.business.entpay.mse.sdk.config.EntpayConfig;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import com.tenpay.business.entpay.mse.sdk.model.*;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import org.springframework.stereotype.Service;

import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@Slf4j
@Service
@RequiredArgsConstructor
public class LklPaymentServiceImpl implements LklPaymentService {

    private final NotifyVerifyService notifyVerifyService;
    private final RedisWrapper redisWrapper;
    private final RedisUtils redisUtils;
    private final RmiPurRpcService rmiPurRpcService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final AccountLinkService accountLinkService;
    private final MessageQueueTemplate messageQueueTemplate;
    private final ScpWqfEntAccountRepoProc scpWqfEntAccountRepoProc;

    private final MessageDelyQueueService messageDelyQueueService;
    private final OrgStoreRpcService orgStoreRpcService;
    private final OrgOuRpcService orgOuRpcService;


    @Override
    public OnlineLolPayOrderResponseVO createMpPayOnline(OnlineLklPayOrderParamVO param) {
        try {
            String docCls = param.getDocNo().substring(0, 2);
            String docNo = param.getDocNo();

            //构建支付明细
            OnlineLolPayOrderResponseVO onlineLolPayOrderResponseVO = buildPayItems(param, docCls);
            if (onlineLolPayOrderResponseVO != null) {
                return onlineLolPayOrderResponseVO;
            }
            buildPaymentMapParam(param);
            OnlineLolPayOrderResponseVO pay = TcslPay.pay(param);

            if(pay == null || pay.getPayUrl() == null){
                throw new BusinessException("获取支付链接失败");
            }

            //写入mq队列
            ScpOrderUpdatePayStatusMqParam updateParamVO = new ScpOrderUpdatePayStatusMqParam();
            updateParamVO.setBusinessKey(ScpOrderUpdatePayStatusMqParam.SCP_ORDER_UPDATE_PAY_STATUS_CHANNEL);
            updateParamVO.setDocNo(param.getDocNo());
            updateParamVO.setPaymentId(pay.getTradeNo());
            updateParamVO.setAmt(param.getAmt());
            updateParamVO.setPayerName(param.getPayerName());
            updateParamVO.setDocCls(docCls);
            messageQueueTemplate.publishMessageSync("yst-suplan", ScpOrderUpdatePayStatusMqParam.SCP_ORDER_UPDATE_PAY_STATUS_CHANNEL, updateParamVO);
            redisUtils.set(ScpConstant.SCP_ONLINE_PAY + docNo, JSONUtil.toJsonStr(pay.getPayUrl()), 25, TimeUnit.HOURS);
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime expireTime = now.plusDays(1);
            Duration duration = Duration.between(now, expireTime);
            messageDelyQueueService.resettingOrderExpireTime(ScpConstant.SCP_ONLINE_PAY + docNo, duration.toMillis());
            return pay;
        } catch (Exception e) {
            throw new BusinessException("拉卡拉支付失败" + e.getMessage());
        }
    }

    @Override
    public BalanceResponseVO queryBalance(QueryBalanceParamVO param) {
        try {
            return TcslPay.queryBalance(param);
        } catch (Exception e) {
            throw new BusinessException("拉卡拉余额查询失败" + e.getMessage());
        }
    }

    @Override
    public String queryAccountDtl(QueryAccountDtlParamVO param) {
        try {
            return TcslPay.queryAccountDtl(param);
        } catch (Exception e) {
            throw new BusinessException("拉卡拉财务明细查询失败" + e.getMessage());
        }
    }

    private OnlineLolPayOrderResponseVO buildPayItems(OnlineLklPayOrderParamVO param,  String docCls) {
        OnlineLolPayOrderResponseVO onlineLolPayOrderResponseVO = new OnlineLolPayOrderResponseVO();
        Object obj = redisUtils.get(ScpConstant.SCP_ONLINE_PAY + param.getDocNo());
        OnlineLklPayOrderParamVO.PayeeInfoVO payeeInfoVO = new OnlineLklPayOrderParamVO.PayeeInfoVO();
        payeeInfoVO.setSubTradeAmount(param.getAmt().setScale(2, RoundingMode.HALF_UP)+"");
        List<OrgOuBankRpcDTO> ouBank = orgOuRpcService.findOuBank(param.getOuId());
        if (ouBank == null || ouBank.isEmpty()) {
            throw new BusinessException("销售方未绑定银行卡");
        }
        Optional<OrgOuBankRpcDTO> in = ouBank.stream().filter(a -> a.getAccType().equals("IN")).findAny();
        if (in.isEmpty()) {
            throw new BusinessException("销售方未绑定银行卡");
        }
        OrgOuBankRpcDTO orgOuBankRpcDTO = in.get();
        payeeInfoVO.setPayeeAccountNo(orgOuBankRpcDTO.getBankAcc());
        payeeInfoVO.setPayeeName(orgOuBankRpcDTO.getHolderName());
        payeeInfoVO.setSubOutTradeNo(param.getDocNo());
        param.setPayeeInfo(List.of(payeeInfoVO));
        if ("PO".equals(docCls)) {
            var onlinePayInfo = rmiPurRpcService.findOnlinePayInfo(param.getDocId());
            if (onlinePayInfo == null) {
                throw new BusinessException("支付订单不存在，请联系管理员");
            }
            if (onlinePayInfo.getOnlinePayFlag()) {
                throw new BusinessException("订单已支付");
            }
            if (obj != null && !onlinePayInfo.getOnlinePayFlag()) {
                String url = JSON.parseObject((String) obj, String.class);
                onlineLolPayOrderResponseVO.setPayUrl(url);
                return onlineLolPayOrderResponseVO;
            }
        } else {
            var onlinePayInfo = rmiInvStkRpcService.findOnlinePayInfo(param.getDocId());
            if (onlinePayInfo == null) {
                throw new BusinessException("支付订单不存在，请联系管理员");
            }
            if (onlinePayInfo.getOnlinePayFlag()) {
                throw new BusinessException("订单已支付");
            }
            if (obj != null && !onlinePayInfo.getOnlinePayFlag()) {
                String url = JSON.parseObject((String) obj, String.class);
                onlineLolPayOrderResponseVO.setPayUrl(url);
                return onlineLolPayOrderResponseVO;
            }
        }
        return null;
    }


    private void buildPaymentMapParam(OnlineLklPayOrderParamVO param) {
        List<OrgBankRpcDTO> bankByStoreCode = orgStoreRpcService.findBankByStoreCode(param.getStoreCode());
        if (bankByStoreCode == null || bankByStoreCode.isEmpty()) {
            throw new BusinessException("门店["+param.getStoreCode()+"]未绑定银行信息");
        }
        Optional<OrgBankRpcDTO> orgBankRpcDTO = bankByStoreCode.stream().filter(bank -> bank.getOpenBank().equals("拉卡拉")).findAny();
        if(orgBankRpcDTO.isEmpty()){
            throw new BusinessException("门店["+param.getStoreCode()+"]未绑定拉卡拉银行信息");
        }
        OrgBankRpcDTO orgBankRpcDTO1 = orgBankRpcDTO.get();
        param.setPayerName(orgBankRpcDTO1.getName());
        param.setPayerNo(orgBankRpcDTO1.getCardNo());
        param.setPayerType(orgBankRpcDTO1.getType());

    }

    @Override
    public String paymentNotify(String body, String authorization) throws EntpayException, JSONException {
        // 验签并获取model
        PaymentNotifyModel model = NotifyHandler.handlerWebhook(body, authorization, PaymentNotifyModel.class,
                EntpayConfig.getRealTbepPublicKey(null));
        log.info("支付回调通知数据：{}", JSONUtil.toJsonStr(model));
        notifyVerifyService.processNotify(model);
        // 封装响应参数
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("retcode", 0);
        jsonObject.put("retmsg", "SUCCESS");
        return jsonObject.toString();
    }

    private PaymentQRParam constructQRPaymentParam(PayOrderReqDTO param) {
        PaymentQRParam paymentQRParam = new PaymentQRParam();
        BeanUtils.copyProperties(constructCommonParam(param), paymentQRParam);
        Object o = redisWrapper.apply(() -> {
            return redisUtils.get(ScpConstant.ENT_PAY_PROPERTIES);
        }, null);
        if (o == null) {
            throw new BusinessException("请联系管理员配置微企付信息");
        }
        EntpayProperties entpayProperties = JSONUtil.toBean(o.toString(), EntpayProperties.class);
        // 支付回调url
        PaymentNotifyUrl paymentNotifyUrl = PaymentNotifyUrl.builder()
                .serverNotifyUrl(entpayProperties.getServerNotifyUrl())
                .build();
        paymentQRParam.setNotifyUrl(paymentNotifyUrl);
        return paymentQRParam;
    }

    private PaymentMpParam constructMPPaymentParam(PayOrderReqDTO param) {
        PaymentMpParam paymentMpParam = new PaymentMpParam();
        BeanUtils.copyProperties(constructCommonParam(param), paymentMpParam);
        Object o = redisWrapper.apply(() -> {
            return redisUtils.get(ScpConstant.ENT_PAY_PROPERTIES);
        }, null);
        if (o == null) {
            throw new BusinessException("请联系管理员配置微企付信息");
        }
        EntpayProperties entpayProperties = JSONUtil.toBean(o.toString(), EntpayProperties.class);
        FrontCallbackUrl frontCallbackUrl = FrontCallbackUrl.builder()
                .mpAppid(entpayProperties.getMpAppid())
                .mpUsername(entpayProperties.getMpUsername())
                .mpPath(param.getMpPath())
                .build();

        // 支付回调url
        PaymentNotifyUrl paymentNotifyUrl = PaymentNotifyUrl.builder()
                .serverNotifyUrl(entpayProperties.getServerNotifyUrl())
                .frontCallbackUrl(frontCallbackUrl)
                .build();
        paymentMpParam.setNotifyUrl(paymentNotifyUrl);
        return paymentMpParam;

    }

    /**
     * 构造支付公共参数
     *
     * @param param
     * @return
     */
    private PaymentParam constructCommonParam(PayOrderReqDTO param) {
        //收款方信息
        PaymentPayee payee = PaymentPayee.builder()
                .entId(param.getEntId())
                .entName(param.getEntName())
                .entAcctId(param.getEntAccId())
                .bankAccountNumberLast4(param.getBankAccountLast4())
                .build();

        // 订单行信息
        List<Goods> goodsList = param.getGoods();

        PaymentRiskControl paymentRiskControl = PaymentRiskControl.builder()
                .deviceId(param.getDeviceId())
                .payerClientIp(param.getPayerClientIp())
                .payerUa(param.getPayerUa())
                .createTime(param.getCreateTime())
                .pickType(param.getPickType())
                .pickDescription(param.getPickDescription())
                .build();

        // 支付下单
        StoreInfo storeInfo = StoreInfo.builder()
                .id(param.getStoreId())
                .name(param.getStoreName())
                .areaCode(param.getStoreAreaCode())
                .build();

        // 场景信息
        SceneInfo sceneInfo = SceneInfo.builder()
                .storeInfo(storeInfo)
                .build();
        // 付款人信息
        List<PayerInfo> payerOptions = new ArrayList<>();
        PayerInfo payerInfo = PayerInfo.builder().payerName(param.getPayerName())
                .assignPayType(param.getPayerType()).build();
        payerOptions.add(payerInfo);

        return PaymentParam.builder()
                .outPaymentId(param.getOutPaymentId())
                .amount(param.getAmount())
                .currency(param.getCurrency())
                .expireTime(param.getExpireTime())
                .payee(payee)
                .goods(goodsList)
                .memo(param.getMemo())
                .attachment(param.getAttachment())
                .riskControl(paymentRiskControl)
                .sceneInfo(sceneInfo)
                .profitAllocationFlag(param.getProfitAllocationFlag())
                .payerOptions(payerOptions)
                .build();
    }
}
