package com.elitesland.scp.lakalapay.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel("在线支付入参")
public class OnlineLolPayOrderResponseVO implements Serializable {
    private static final long serialVersionUID = 6074350548106028859L;

    @ApiModelProperty(value = "系统交易单号")
    private String tradeNo;

    @ApiModelProperty(value = "商户交易单号")
    private String outTradeNo;

    @ApiModelProperty(value = "支付状态 (accept-已受理 create-已创建 close-已关闭 success-支付成功 fail-支付失败 u-未知 pro-处理中)", required = true)
    private String payState;

    @ApiModelProperty(value = "交易失败原因")
    private String errMsg;

    @ApiModelProperty(value = "发起收银台支付url，小程序跳转path")
    private String payUrl;

    @ApiModelProperty(value = "发起小程序支付appid")
    private String appid;



}
