package com.elitesland.scp.lakalapay.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("在线支付入参")
public class OnlineLolPayOrderResultResponseVO implements Serializable {
    private static final long serialVersionUID = 6074350548106028859L;

    @ApiModelProperty(value = "查询结果 (0-成功 1-无此交易)", required = true)
    private String resultCode;

    @ApiModelProperty(value = "系统交易单号", required = true)
    private String tradeNo;

    @ApiModelProperty(value = "商户交易订单号", required = true)
    private String outTradeNo;

    @ApiModelProperty(value = "交易状态 (accepted-已受理 fail-失败 success-支付成功)", required = true)
    private String payState;

    @ApiModelProperty(value = "支付成功时间 (yyyy-MM-dd HH:mm:ss)")
    private String paySuccessTime;

    @ApiModelProperty(value = "失败原因")
    private String errMsg;

    @ApiModelProperty(value = "付款账号")
    private String payerAccountNo;

    @ApiModelProperty(value = "收款账号")
    private String payeeAccountNo;

    @ApiModelProperty(value = "交易金额 (保留两位小数，单位:元)")
    private String tradeAmount;

    @ApiModelProperty(value = "外部系统业务单号")
    private String outBussNo;

    @ApiModelProperty(value = "子订单列表 (主单对应的子单列表，json格式)")
    private Object subList;
}
