package com.elitesland.scp.rmi;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invIo.InvIoCalcParamRpcDTO;
import com.elitesland.inv.dto.invIo.InvIoCalcRpcDTO;
import com.elitesland.inv.dto.invTro.InvTroDRpcDTO;
import com.elitesland.inv.dto.invTro.InvTroOnlinePayParamDTO;
import com.elitesland.inv.dto.invTro.InvTroOnlinePayRpcDTO;
import com.elitesland.inv.dto.invTro.InvTroPayRpcDTO;
import com.elitesland.inv.dto.invstk.*;
import com.elitesland.inv.dto.invwh.InvWhDetailRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.provider.InvIoProvider;
import com.elitesland.inv.provider.InvStkProvider;
import com.elitesland.inv.provider.InvTroProvider;
import com.elitesland.inv.provider.InvWhProvider;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Component
@Slf4j
@RequiredArgsConstructor
public class RmiInvStkRpcService {

    private final InvStkProvider invStkProvider;
    private final InvWhProvider invWhProvider;
    private final InvTroProvider invTroProvider;
    private final InvIoProvider invIoProvider;

    public List<InvStkQueryRpcResult> queryInvStk(InvStkQueryRpcParam param) {
        log.info("查询库存可用量列表入参：" + JSON.toJSONString(param));
        List<InvStkQueryRpcResult> invStkList = invStkProvider.queryInvStk(param);
        log.info("查询库存可用量列表出参：" + JSON.toJSONString(invStkList));
        return invStkList;
    }

    /**
     * 仓库查询
     *
     * @param param
     * @return
     */
    public List<InvWhDetailRpcDTO> findWhAreaDTOByParam(InvWhRpcDtoParam param) {
        log.info("查询仓库及库区信息：" + JSON.toJSONString(param));
        ApiResult<List<InvWhDetailRpcDTO>> whAreaDTOByParam = invWhProvider.findWhAreaDTOByParam(param);
        if (!whAreaDTOByParam.isSuccess()) {
            throw new BusinessException("查询仓库及库区信息:" + whAreaDTOByParam.getMsg());
        }
        return whAreaDTOByParam.getData();
    }

    public ApiResult<List<InvWhRpcDTO>> findWhDTOByParam(InvWhRpcDtoParam param) {
        try {
            log.info("查询仓库表头的接口入参：【{}】", JSON.toJSONString(param));
            return invWhProvider.findWhDTOByParam(param);
        } catch (Exception e) {
            log.error("查询仓库表头异常:{0}", e);
            throw new BusinessException(ApiCode.FAIL, "查询仓库表头的接口异常" + e);
        }
    }

    public Map<Long, InvWhRpcSimpleDTO> findInvWhBaseMap(List<Long> whIds) {
        log.info("查询仓库表头的接口入参：【{}】", JSON.toJSONString(whIds));
        if (CollUtil.isEmpty(whIds)) {
            return new HashMap<>();
        }
        ApiResult<List<InvWhRpcSimpleDTO>> result = invWhProvider.querySimple(whIds);
        if (!result.isSuccess()) {
            throw new BusinessException(ApiCode.FAIL, "查询仓库表头的接口异常" + result.getMsg());
        }
        return result.getData().stream().collect(Collectors.toMap(InvWhRpcSimpleDTO::getWhId, Function.identity()));
    }

    public Map<String, InvWhRpcSimpleDTO> findInvWhBaseMapByCode(List<String> whCodes) {
        log.info("查询仓库表头的接口入参：【{}】", JSON.toJSONString(whCodes));
        if (CollUtil.isEmpty(whCodes)) {
            return new HashMap<>();
        }
        ApiResult<List<InvWhRpcSimpleDTO>> result = invWhProvider.findSimpleWhByWhCodes(whCodes);
        if (!result.isSuccess()) {
            throw new BusinessException(ApiCode.FAIL, "查询仓库表头的接口异常" + result.getMsg());
        }
        return result.getData().stream().collect(Collectors.toMap(InvWhRpcSimpleDTO::getWhCode, Function.identity()));
    }

    public InvWhRpcSimpleDTO findSimpleWhByCode(String whCode) {
        log.info("查询仓库表头的接口入参：【{}】", JSON.toJSONString(whCode));
        ApiResult<List<InvWhRpcSimpleDTO>> simpleWhByWhCodes = invWhProvider.findSimpleWhByWhCodes(List.of(whCode));
        if (!simpleWhByWhCodes.isSuccess() || CollUtil.isEmpty(simpleWhByWhCodes.getData())) {
            throw new BusinessException("查询仓库表头的接口异常" + simpleWhByWhCodes.getMsg());
        }
        return simpleWhByWhCodes.getData().get(0);
    }

    public List<InvTroPayRpcDTO> payInfo(Long id) {
        ApiResult<List<InvTroPayRpcDTO>> payInfoByTroId = invTroProvider.findPayInfoByTroId(id);
        if (!payInfoByTroId.isSuccess()) {
            throw new BusinessException("查询调拨订单支付信息异常:" + payInfoByTroId.getMsg());
        }
        return payInfoByTroId.getData();
    }

    public List<InvTroDRpcDTO> findTroDByTroId(Long troId) {
        ApiResult<List<InvTroDRpcDTO>> payInfoByTroId = invTroProvider.findTroDByMasId(troId);
        if (!payInfoByTroId.isSuccess()) {
            throw new BusinessException("查询调拨订单信息异常:" + payInfoByTroId.getMsg());
        }
        return payInfoByTroId.getData();
    }

    public void updateOnlinePay(InvTroOnlinePayParamDTO payParamDTO) {
        try {
            invTroProvider.updateOnlinePay(payParamDTO);
        } catch (Exception e) {
            throw new BusinessException("更新在线支付信息异常");
        }
    }

    public InvTroOnlinePayRpcDTO findOnlinePayInfo(Long troId) {
        InvTroOnlinePayRpcDTO onlinePayInfo = invTroProvider.findOnlinePayInfo(troId);
        log.info("查询调拨订单:{},支付信息:{}", troId, JSONUtil.toJsonStr(onlinePayInfo));
        return onlinePayInfo;
    }

    /**
     * 小程序商品库存查询
     *
     * @param param
     * @return
     */
    public PagingVO<InvStkStoreMpRpcDTO> queryStoreMpInvStkMap(InvStkMpQueryRpcParam param) {
        PagingVO<InvStkStoreMpRpcDTO> invStkStoreMpRpcDTOS = invStkProvider.queryStoreMpInvStk(param);
        log.info("查询库存可用量列表出参：" + JSON.toJSONString(invStkStoreMpRpcDTOS));
        return invStkStoreMpRpcDTOS;
    }

    /**
     * 关闭调拨订单
     *
     * @param ids
     */
    public void closeTro(List<Long> ids) {
        try {
            invTroProvider.closeTro(ids);
        } catch (Exception e) {
            throw new BusinessException("调用库存域：关闭调拨订单异常" + e.toString());
        }
    }

    public List<InvWhItemTotalStkRpcDTO> queryInvWhItemTotalStk(InvWhItemTotalStkRpcParam param) {
        log.info("查询库存可用量[queryInvWhItemTotalStk]入参：" + JSON.toJSONString(param));
        List<InvWhItemTotalStkRpcDTO> invStkList = invStkProvider.queryInvWhItemTotalStk(param);
            log.info("查询库存可用量[queryInvWhItemTotalStk]出参：" + JSON.toJSONString(invStkList));
        return invStkList;
    }

    public List<InvIoCalcRpcDTO> calcIoByMrp(List<InvIoCalcParamRpcDTO> param) {
        log.info("MRP计划计算库存流水开始：" + JSON.toJSONString(param));
        ApiResult<List<InvIoCalcRpcDTO>> result = invIoProvider.calcByMrp(param);
        if (!result.isSuccess()) {
            throw new BusinessException("MRP计划计算库存流水:" + result.getMsg());
        }
        log.info("MRP计划计算库存流水结束：" + JSON.toJSONString(result.getData()));
        return result.getData();
    }
}
