package com.elitesland.scp.rmi;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.item.service.ItmItemBomRpcService;
import com.elitesland.support.provider.pri.service.PriPriceRpcService;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import com.elitesland.support.provider.pri.service.param.ItmBomPriceRpcDtoParam;
import com.elitesland.support.provider.pri.service.param.ItmPriPriceRpcDtoParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Component
@Slf4j
@RequiredArgsConstructor
public class RmiPriceRpcService {

    private final PriPriceRpcService priPriceRpcService;

    private final ItmItemBomRpcService itmItemBomRpcService;

    public List<PriPriceRpcDTO> findPriceByParam(List<ItmPriPriceRpcDtoParam> paramList) {
        log.info("调用支撑域-获取商品价格方法,时间：{}，入参：{}", LocalDateTime.now(), JSONObject.toJSONString(paramList));
        try {
            ApiResult<List<PriPriceRpcDTO>> priPrice = priPriceRpcService.findPriPrice(paramList);
            log.info("调用支撑域-获取商品价格结果:{}", JSONUtil.toJsonStr(priPrice));
            if (priPrice != null && priPrice.isSuccess() && CollUtil.isNotEmpty(priPrice.getData())) {
                List<PriPriceRpcDTO> result = priPrice.getData();
                log.info("调用支撑域-获取商品价格结果:{}", JSONUtil.toJsonStr(result));
                return result;
            }
        } catch (Exception e) {
            log.error("查询商品价格:", e);
            throw new BusinessException("支撑域服务异常", e);
        }
        return new ArrayList<>();
    }

    public List<PriPriceRpcDTO> findBomPriceByParam(List<ItmBomPriceRpcDtoParam> params) {
        log.info("调用支撑域-获取子件商品价格方法,时间：{}，入参：{}", LocalDateTime.now(), JSONObject.toJSONString(params));
        try {
            ApiResult<List<PriPriceRpcDTO>> priPrice = itmItemBomRpcService.findBomItemPriceByParam(params);
            log.info("调用支撑域-获取子件商品价格结果:{}", JSONUtil.toJsonStr(priPrice));
            if (priPrice != null && priPrice.isSuccess() && CollUtil.isNotEmpty(priPrice.getData())) {
                List<PriPriceRpcDTO> result = priPrice.getData();
                log.info("调用支撑域-获取子件商品价格结果:{}", JSONUtil.toJsonStr(result));
                return result;
            }
        } catch (Exception e) {
            log.error("查询子件商品价格:", e);
            throw new BusinessException("支撑域服务异常", e);
        }
        return new ArrayList<>();
    }

    public List<PriPriceRpcDTO> findBomAndMainItemPriceByParam(List<ItmBomPriceRpcDtoParam> params) {
        log.info("调用支撑域-获取子件和主件商品价格方法,时间：{}，入参：{}", LocalDateTime.now(), JSONObject.toJSONString(params));
        try {
            ApiResult<List<PriPriceRpcDTO>> priPrice = itmItemBomRpcService.findBomAndMainItemPriceByParam(params);
            log.info("调用支撑域-获取子件和主件商品价格结果:{}", JSONUtil.toJsonStr(priPrice));
            if (priPrice != null && priPrice.isSuccess() && CollUtil.isNotEmpty(priPrice.getData())) {
                List<PriPriceRpcDTO> result = priPrice.getData();
                log.info("调用支撑域-获取子件和主件商品价格结果:{}", JSONUtil.toJsonStr(result));
                return result;
            }
        } catch (Exception e) {
            log.error("查询子件和主件商品价格:", e);
            throw new BusinessException("支撑域服务异常", e);
        }
        return new ArrayList<>();
    }
}
