/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.wqf;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.utils.StringUtils;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountApplyDImportVO;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountApplyDRespVO;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountApplyDSaveVO;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountApplyImportParam;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountApplyPageParam;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountApplyPageVO;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountApplyRespVO;
import com.elitesland.scp.application.facade.vo.resp.wqf.ScpWqfEntAccountApplySaveVO;
import com.elitesland.scp.application.service.wqf.ScpWqfEntAccountApplyService;
import com.elitesland.scp.domain.convert.wqf.ScpWqfEntAccountApplyConvert;
import com.elitesland.scp.domain.convert.wqf.ScpWqfEntAccountApplyDConvert;
import com.elitesland.scp.domain.entity.wqf.ScpWqfEntAccountApplyDDO;
import com.elitesland.scp.domain.entity.wqf.ScpWqfEntAccountApplyDO;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.dto.wqf.ScpWqfEntAccountApplyDDTO;
import com.elitesland.scp.infr.dto.wqf.ScpWqfEntAccountApplyDTO;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepoProc;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountApplyDRepo;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountApplyDRepoProc;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountApplyRepo;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountApplyRepoProc;
import com.elitesland.scp.param.ScpWhNetRelationRpcDtoParam;
import com.elitesland.scp.pay.service.AccountBatchBindService;
import com.elitesland.scp.pay.vo.AccountBindParamVO;
import com.elitesland.scp.pay.vo.BankAccountParamVO;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ScpWqfEntAccountApplyServiceImpl
implements ScpWqfEntAccountApplyService {
    private static final Logger log = LoggerFactory.getLogger(ScpWqfEntAccountApplyServiceImpl.class);
    private final OrgOuRpcService orgOuRpcService;
    private final ScpWqfEntAccountApplyRepoProc scpWqfEntAccountApplyRepoProc;
    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpWqfEntAccountApplyDRepo scpWqfEntAccountApplyDRepo;
    private final ScpWqfEntAccountApplyRepo scpWqfEntAccountApplyRepo;
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final ScpWqfEntAccountApplyDRepoProc scpWqfEntAccountApplyDRepoProc;
    private final UdcProvider udcProvider;
    private final AccountBatchBindService accountBatchBindService;
    private final ScpWhNetRelationRepoProc scpWhNetRelationRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ScpWqfEntAccountApplyPageVO> page(ScpWqfEntAccountApplyPageParam paramVO) {
        PagingVO<ScpWqfEntAccountApplyPageVO> page = this.scpWqfEntAccountApplyRepoProc.page(paramVO);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            List ouIds = page.getRecords().stream().map(ScpWqfEntAccountApplyPageVO::getOuId).distinct().collect(Collectors.toList());
            List simpleOuDto = this.orgOuRpcService.findSimpleOuDto(ouIds);
            Map<Long, OrgOuRpcSimpleDTO> ouMap = simpleOuDto.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getId, v -> v, (e1, e2) -> e1));
            page.getRecords().forEach(d -> {
                OrgOuRpcSimpleDTO ou = (OrgOuRpcSimpleDTO)ouMap.get(d.getOuId());
                if (ou != null) {
                    d.setOuName(ou.getOuName());
                }
            });
        }
        return page;
    }

    @Override
    public ScpWqfEntAccountApplyRespVO detail(Long id) {
        ScpWqfEntAccountApplyDO applyDO = (ScpWqfEntAccountApplyDO)this.scpWqfEntAccountApplyRepo.findById(id).orElseThrow(new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728"));
        List<ScpWqfEntAccountApplyDDO> applyDDOS = this.scpWqfEntAccountApplyDRepo.findByMasId(id);
        ScpWqfEntAccountApplyRespVO respVo = ScpWqfEntAccountApplyConvert.INSTANCE.doToRespVo(applyDO);
        OrgOuRpcSimpleDTO simpleOuDto = (OrgOuRpcSimpleDTO)this.orgOuRpcService.findSimpleOuDto(List.of(respVo.getOuId())).get(0);
        respVo.setOuCode(simpleOuDto.getOuCode());
        respVo.setOuName(simpleOuDto.getOuName());
        Map accountTypeMap = this.udcProvider.getValueMapByUdcCode("yst-suplan", "WQF_ACCOUNT_TYPE");
        Map wqfBankName = MapUtil.reverse((Map)this.udcProvider.getValueMapByUdcCode("yst-suplan", "WQF_BANK_NAME"));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(applyDDOS)) {
            List<ScpWqfEntAccountApplyDRespVO> respVOS = applyDDOS.stream().map(ScpWqfEntAccountApplyDConvert.INSTANCE::doToRespVo).collect(Collectors.toList());
            List storeIds = respVOS.stream().map(ScpWqfEntAccountApplyDRespVO::getStoreId).distinct().collect(Collectors.toList());
            OrgStoreBaseRpcParam baseRpcParam = new OrgStoreBaseRpcParam();
            baseRpcParam.setStoreIdList(storeIds);
            List dtoList = (List)this.orgStoreRpcService.findOrgStoreBaseByParam(baseRpcParam).computeData();
            Map<Long, OrgStoreBaseRpcDTO> storeMap = dtoList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getId, i -> i, (o, n) -> n));
            respVOS.forEach(d -> {
                OrgStoreBaseRpcDTO storeBaseRpcDTO = (OrgStoreBaseRpcDTO)storeMap.get(d.getStoreId());
                if (storeBaseRpcDTO != null) {
                    d.setStoreName(storeBaseRpcDTO.getStoreName());
                }
                d.setOpenBankCode((String)wqfBankName.get(d.getOpenBank()));
                d.setAccountTypeName((String)accountTypeMap.get(d.getAccountType()));
            });
            respVo.setDetails(respVOS);
        }
        return respVo;
    }

    @Override
    @Transactional
    public String save(ScpWqfEntAccountApplySaveVO createParam) {
        if (createParam.getApplyStatus() == null) {
            createParam.setApplyStatus(UdcEnum.WQF_APPLY_STATUS_DR.getValueCode());
        } else if (!Objects.equals(createParam.getApplyStatus(), UdcEnum.WQF_APPLY_STATUS_DR.getValueCode()) && !Objects.equals(createParam.getApplyStatus(), UdcEnum.WQF_APPLY_STATUS_FAIL.getValueCode())) {
            throw new BusinessException("\u8be5\u3010\u8349\u7a3f\u3011\u6216\u3010\u5904\u7406\u5931\u8d25\u3011\u5355\u636e\u72b6\u6001\u63d0\u4ea4");
        }
        ScpWqfEntAccountApplyDTO applyDTO = ScpWqfEntAccountApplyConvert.INSTANCE.saveVoToDto(createParam);
        applyDTO.setApplyStatus(UdcEnum.WQF_APPLY_STATUS_DR.getValueCode());
        List<ScpWqfEntAccountApplyDSaveVO> details = createParam.getDetails();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(details) && details.size() > 100) {
            throw new BusinessException("\u5355\u6b21\u63d0\u4ea4\u4e0d\u80fd\u8d85\u8fc7100\u6761");
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(details)) {
            long count = details.stream().map(ScpWqfEntAccountApplyDSaveVO::getStoreId).distinct().count();
            if (count != (long)details.size()) {
                throw new BusinessException(ApiCode.FAIL, "\u5b58\u5728\u91cd\u590d\u95e8\u5e97\u4fe1\u606f");
            }
            ScpWhNetRelationRpcDtoParam dtoParam = new ScpWhNetRelationRpcDtoParam();
            dtoParam.setOuCodes(List.of(createParam.getOuCode()));
            dtoParam.setType("0");
            List<ScpWhNetRelationRpcDTO> whNetRelationRpcDTOS = this.scpWhNetRelationRepoProc.findWhNetRelationRpcDtoByParam(dtoParam);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(whNetRelationRpcDTOS)) {
                throw new BusinessException(ApiCode.FAIL, String.format("\u516c\u53f8\u3010%s\u3011 \u672a\u914d\u7f6e\u4ed3\u7f51\u5173\u7cfb\u95e8\u5e97\u4fe1\u606f", createParam.getOuName()));
            }
            List stores = whNetRelationRpcDTOS.stream().map(ScpWhNetRelationRpcDTO::getDemandWhStCode).distinct().collect(Collectors.toList());
            List storeList = details.stream().map(ScpWqfEntAccountApplyDSaveVO::getStoreCode).distinct().collect(Collectors.toList());
            storeList.stream().filter(d -> !stores.contains(d)).findAny().ifPresent(d -> {
                throw new BusinessException(ApiCode.FAIL, String.format("\u516c\u53f8\u3010%s\u3011\u672a\u914d\u7f6e\u4ed3\u7f51\u5173\u7cfb\u95e8\u5e97\u3010%s\u3011\u4fe1\u606f", createParam.getOuName(), d));
            });
        }
        if (createParam.getId() == null) {
            applyDTO.setDocNo(this.rmiSysUserRpcService.sysNumberRuleGenerateCode("WA", new ArrayList<String>()));
            createParam.setDocNo(applyDTO.getDocNo());
            accountApplyDO = ScpWqfEntAccountApplyConvert.INSTANCE.dtoToDo(applyDTO);
            this.scpWqfEntAccountApplyRepo.save(accountApplyDO);
            createParam.setId(accountApplyDO.getId());
        } else {
            accountApplyDO = (ScpWqfEntAccountApplyDO)this.scpWqfEntAccountApplyRepo.findById(createParam.getId()).orElseThrow(new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728"));
            if (!Objects.equals(accountApplyDO.getApplyStatus(), UdcEnum.WQF_APPLY_STATUS_DR.getValueCode()) && !Objects.equals(createParam.getApplyStatus(), UdcEnum.WQF_APPLY_STATUS_FAIL.getValueCode())) {
                throw new BusinessException("\u8be5\u5355\u636e\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539");
            }
            ScpWqfEntAccountApplyConvert.INSTANCE.copyDtoToDo(applyDTO, accountApplyDO);
            this.scpWqfEntAccountApplyRepo.save(accountApplyDO);
            this.scpWqfEntAccountApplyDRepo.deleteByMasId(createParam.getId());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(details)) {
            List<Long> storeIds = details.stream().map(ScpWqfEntAccountApplyDSaveVO::getStoreId).distinct().collect(Collectors.toList());
            List<ScpWqfEntAccountApplyDDTO> wqfEntAccountApplyDDTOS = this.scpWqfEntAccountApplyDRepoProc.findByStoreIdAndOuId(storeIds, createParam.getOuId());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(wqfEntAccountApplyDDTOS)) {
                for (ScpWqfEntAccountApplyDSaveVO detail : details) {
                    Map<Long, ScpWqfEntAccountApplyDDTO> ddtoMap = wqfEntAccountApplyDDTOS.stream().collect(Collectors.toMap(ScpWqfEntAccountApplyDDTO::getStoreId, i -> i, (o, n) -> n));
                    if (!ddtoMap.containsKey(detail.getStoreId())) continue;
                    throw new BusinessException(ApiCode.FAIL, String.format("\u516c\u53f8\u3010%s\u3011\u5df2\u5b58\u5728\u8be5\u95e8\u5e97\u3010%s\u3011\u7684\u5f00\u6237\u7533\u8bf7\u4fe1\u606f", createParam.getOuName(), detail.getStoreCode()));
                }
            }
            AtomicInteger linoNo = new AtomicInteger(0);
            List applyDDTOS = details.stream().map(d -> {
                ScpWqfEntAccountApplyDDTO applyDDTO = ScpWqfEntAccountApplyDConvert.INSTANCE.saveVoToDto((ScpWqfEntAccountApplyDSaveVO)d);
                applyDDTO.setLineNo(linoNo.addAndGet(1));
                applyDDTO.setMasId(createParam.getId());
                return applyDDTO;
            }).collect(Collectors.toList());
            this.scpWqfEntAccountApplyDRepo.saveAll(applyDDTOS.stream().map(ScpWqfEntAccountApplyDConvert.INSTANCE::dtoToDo).collect(Collectors.toList()));
        }
        return createParam.getId().toString();
    }

    @Override
    @Transactional
    public String submit(ScpWqfEntAccountApplySaveVO saveVO) {
        this.save(saveVO);
        ScpWqfEntAccountApplyDO accountApplyDO = (ScpWqfEntAccountApplyDO)this.scpWqfEntAccountApplyRepo.findById(saveVO.getId()).orElseThrow(new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728"));
        List<ScpWqfEntAccountApplyDDO> entAccountApplyDDOS = this.scpWqfEntAccountApplyDRepo.findByMasId(saveVO.getId());
        accountApplyDO.setApplyStatus(UdcEnum.WQF_APPLY_STATUS_INIT.getValueCode());
        this.scpWqfEntAccountApplyRepo.save(accountApplyDO);
        this.wqfAccountBindHadler(accountApplyDO, entAccountApplyDDOS);
        return saveVO.getId().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wqfAccountBindHadler(ScpWqfEntAccountApplyDO accountApplyDO, List<ScpWqfEntAccountApplyDDO> entAccountApplyDDOS) {
        List simpleOuDto = this.orgOuRpcService.findSimpleOuDto(Collections.singletonList(accountApplyDO.getOuId()));
        Map<String, OrgOuRpcSimpleDTO> ouMap = simpleOuDto.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, v -> v, (e1, e2) -> e1));
        OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(accountApplyDO.getOuCode());
        if (ouRpcSimpleDTO == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f");
        }
        try {
            AccountBindParamVO bindParamVO = new AccountBindParamVO();
            bindParamVO.setEntId(accountApplyDO.getEntId());
            bindParamVO.setOutRequestNo(accountApplyDO.getDocNo());
            List<BankAccountParamVO> bankAccountList = entAccountApplyDDOS.stream().map(d -> {
                BankAccountParamVO accountParamVO = new BankAccountParamVO();
                accountParamVO.setAccountType(d.getAccountType());
                accountParamVO.setBankAccountName(ouRpcSimpleDTO.getOuName());
                accountParamVO.setBankAccountNumber(d.getBankAccount());
                accountParamVO.setBankName(d.getOpenBank());
                accountParamVO.setBankBranchId(d.getBankBranchCode());
                accountParamVO.setBankBranchName(d.getBranchName());
                return accountParamVO;
            }).collect(Collectors.toList());
            bindParamVO.setBankAccountList(bankAccountList);
            log.info("\u8c03\u7528\u5fae\u4f01\u4ed8\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)bindParamVO));
            this.accountBatchBindService.accountBind(bindParamVO);
            log.info("\u8c03\u7528\u5fae\u4f01\u4ed8\u63a5\u53e3\u6210\u529f\uff1a{}", (Object)JSON.toJSONString((Object)bindParamVO));
            accountApplyDO.setApplyStatus(UdcEnum.WQF_APPLY_STATUS_PROCESSING.getValueCode());
            accountApplyDO.setErrorMsg(null);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5fae\u4f01\u4ed8\u63a5\u53e3\u5931\u8d25", (Throwable)e);
            accountApplyDO.setApplyStatus(UdcEnum.WQF_APPLY_STATUS_FAIL.getValueCode());
            accountApplyDO.setErrorMsg(e.getMessage().length() > 100 ? e.getMessage().substring(0, 100) : e.getMessage());
        }
        finally {
            this.scpWqfEntAccountApplyRepo.save(accountApplyDO);
        }
    }

    @Override
    public ApiResult<List<ScpWqfEntAccountApplyDRespVO>> importDetail(List<ScpWqfEntAccountApplyDImportVO> dates, ScpWqfEntAccountApplyImportParam param) {
        if (CollectionUtils.isEmpty(dates)) {
            throw new BusinessException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        if (dates.size() > 100) {
            throw new BusinessException("\u5bfc\u5165\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7100");
        }
        long count = dates.stream().map(ScpWqfEntAccountApplyDImportVO::getStoreCode).distinct().count();
        if (count != (long)dates.size()) {
            throw new BusinessException(ApiCode.FAIL, "\u5b58\u5728\u91cd\u590d\u95e8\u5e97\u4fe1\u606f");
        }
        List storeCodes = dates.stream().map(ScpWqfEntAccountApplyDImportVO::getStoreCode).distinct().collect(Collectors.toList());
        List storeDetailRpcDTOS = this.orgStoreRpcService.queryByStoreCodes(storeCodes);
        HashMap storeMap = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)storeDetailRpcDTOS) ? new HashMap() : storeDetailRpcDTOS.stream().collect(Collectors.toMap(OrgStoreDetailRpcDTO::getStoreCode, i -> i, (o, n) -> n));
        Map wqfAccountType = MapUtil.reverse((Map)this.udcProvider.getValueMapByUdcCode("yst-suplan", "WQF_ACCOUNT_TYPE"));
        Map wqfBankName = MapUtil.reverse((Map)this.udcProvider.getValueMapByUdcCode("yst-suplan", "WQF_BANK_NAME"));
        ArrayList<ScpWqfEntAccountApplyDRespVO> list = new ArrayList<ScpWqfEntAccountApplyDRespVO>();
        for (int i2 = 0; i2 < dates.size(); ++i2) {
            int row = i2 + 2;
            ScpWqfEntAccountApplyDImportVO importVO = dates.get(i2);
            if (wqfBankName.get(importVO.getOpenBank()) == null) {
                throw new BusinessException("\u7b2c" + row + "\u884c\uff0c\u5f00\u6237\u94f6\u884c\u3010" + importVO.getOpenBank() + "\u3011\u4e0d\u5b58\u5728");
            }
            if (StringUtils.isBlank((CharSequence)importVO.getStoreCode())) {
                throw new BusinessException("\u7b2c" + row + "\u884c\uff0c\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (storeMap.get(importVO.getStoreCode()) == null) {
                throw new BusinessException("\u7b2c" + row + "\u884c\uff0c\u95e8\u5e97\u7f16\u7801\u3010" + importVO.getStoreCode() + "\u3011\u4e0d\u5b58\u5728");
            }
            Long l = ((OrgStoreDetailRpcDTO)storeMap.get(importVO.getStoreCode())).getOuId();
            if (wqfAccountType.get(importVO.getAccountTypeName()) == null) {
                throw new BusinessException("\u7b2c" + row + "\u884c\uff0c\u8d26\u6237\u7c7b\u578b\u3010" + importVO.getAccountTypeName() + "\u3011\u4e0d\u5b58\u5728");
            }
            ScpWqfEntAccountApplyDRespVO vo = ScpWqfEntAccountApplyDConvert.INSTANCE.importVoToRespVo(importVO);
            vo.setStoreId(((OrgStoreDetailRpcDTO)storeMap.get(importVO.getStoreCode())).getId());
            vo.setStoreName(((OrgStoreDetailRpcDTO)storeMap.get(importVO.getStoreCode())).getStoreName());
            vo.setAccountType((String)wqfAccountType.get(importVO.getAccountTypeName()));
            vo.setAccountTypeName(importVO.getAccountTypeName());
            list.add(vo);
        }
        return ApiResult.ok(list);
    }

    @Override
    @Transactional
    public List<Long> batchSubmit(List<Long> ids) {
        List applyDOList = this.scpWqfEntAccountApplyRepo.findAllById(ids);
        applyDOList.stream().filter(d -> !UdcEnum.WQF_APPLY_STATUS_DR.getValueCode().equals(d.getApplyStatus())).findAny().ifPresent(m -> {
            throw new BusinessException(String.format("\u5355\u636e\u3010%s\u3011\u4e0d\u5141\u8bb8\u63d0\u4ea4,\u8bf7\u9009\u62e9\u3010\u8349\u7a3f\u3011\u72b6\u6001\u5355\u636e", m.getDocNo()));
        });
        Map<Long, ScpWqfEntAccountApplyDO> applyDOMap = applyDOList.stream().collect(Collectors.toMap(BaseModel::getId, i -> i, (o, n) -> n));
        List<ScpWqfEntAccountApplyDDO> accountApplyDDOS = this.scpWqfEntAccountApplyDRepo.findAllByMasIdIn(ids);
        Map<Long, List<ScpWqfEntAccountApplyDDO>> detailMap = accountApplyDDOS.stream().collect(Collectors.groupingBy(ScpWqfEntAccountApplyDDO::getMasId));
        ArrayList<ScpWqfEntAccountApplyDO> sucessList = new ArrayList<ScpWqfEntAccountApplyDO>();
        for (Long id : ids) {
            ScpWqfEntAccountApplyDO accountApplyDO = applyDOMap.get(id);
            List<ScpWqfEntAccountApplyDDO> accountApplyDDOList = detailMap.get(id);
            accountApplyDO.setApplyStatus(UdcEnum.WQF_APPLY_STATUS_INIT.getValueCode());
            this.wqfAccountBindHadler(accountApplyDO, accountApplyDDOList);
            sucessList.add(accountApplyDO);
        }
        this.scpWqfEntAccountApplyRepo.saveAll(sucessList);
        return sucessList.stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void delete(List<Long> ids) {
        List applyDOList = this.scpWqfEntAccountApplyRepo.findAllById(ids);
        applyDOList.stream().filter(d -> !UdcEnum.WQF_APPLY_STATUS_DR.getValueCode().equals(d.getApplyStatus()) && !UdcEnum.WQF_APPLY_STATUS_FAIL.getValueCode().equals(d.getApplyStatus())).findAny().ifPresent(m -> {
            throw new BusinessException(String.format("\u5355\u636e\u3010%s\u3011\u4e0d\u5141\u8bb8\u5220\u9664,\u8bf7\u9009\u62e9\u3010\u8349\u7a3f\u3011\u6216\u3010\u5904\u7406\u5931\u8d25\u3011\u72b6\u6001\u5355\u636e", m.getDocNo()));
        });
        this.scpWqfEntAccountApplyRepo.deleteAllById(ids);
        this.scpWqfEntAccountApplyDRepo.deleteAllByMasIdIn(ids);
    }

    public ScpWqfEntAccountApplyServiceImpl(OrgOuRpcService orgOuRpcService, ScpWqfEntAccountApplyRepoProc scpWqfEntAccountApplyRepoProc, OrgStoreRpcService orgStoreRpcService, ScpWqfEntAccountApplyDRepo scpWqfEntAccountApplyDRepo, ScpWqfEntAccountApplyRepo scpWqfEntAccountApplyRepo, RmiSysUserRpcService rmiSysUserRpcService, ScpWqfEntAccountApplyDRepoProc scpWqfEntAccountApplyDRepoProc, UdcProvider udcProvider, AccountBatchBindService accountBatchBindService, ScpWhNetRelationRepoProc scpWhNetRelationRepoProc) {
        this.orgOuRpcService = orgOuRpcService;
        this.scpWqfEntAccountApplyRepoProc = scpWqfEntAccountApplyRepoProc;
        this.orgStoreRpcService = orgStoreRpcService;
        this.scpWqfEntAccountApplyDRepo = scpWqfEntAccountApplyDRepo;
        this.scpWqfEntAccountApplyRepo = scpWqfEntAccountApplyRepo;
        this.rmiSysUserRpcService = rmiSysUserRpcService;
        this.scpWqfEntAccountApplyDRepoProc = scpWqfEntAccountApplyDRepoProc;
        this.udcProvider = udcProvider;
        this.accountBatchBindService = accountBatchBindService;
        this.scpWhNetRelationRepoProc = scpWhNetRelationRepoProc;
    }
}

