/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.order;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetStatusParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetSelectRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandSetSaveVO;
import com.elitesland.scp.application.service.order.ScpDemandOrderSetService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8ba2\u8d27\u96c6\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/order/set"}, produces={"application/json"})
public class ScpDemandOrderSetController {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderSetController.class);
    private final ScpDemandOrderSetService scpDemandOrderSetService;

    @ApiOperation(value="\u8ba2\u8d27\u96c6-  \u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<ScpDemandSetPageRespVO>> queryDemandSet(@RequestBody ScpDemandSetPageParamVO paramVO) {
        log.info("[SCP-DEMAND-SET] queryDemandSet  param ={}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok(this.scpDemandOrderSetService.queryDemandSetList(paramVO));
    }

    @ApiOperation(value="\u8ba2\u8d27\u96c6 - \u67e5\u8be2\u8ba2\u8d27\u96c6\u660e\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/findIdOne/{id}"})
    public ApiResult<ScpDemandSetRespVO> findIdOne(@PathVariable Long id) {
        log.info("[SCP-DEMAND-SET] findIdOne, id ={}", (Object)id);
        return this.scpDemandOrderSetService.findDemandSetById(id).map(ApiResult::ok).orElse(ApiResult.fail((ApiCode)ApiCode.NOT_FOUND));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u8ba2\u8d27\u96c6 - \u4fdd\u5b58")
    public ApiResult<Long> saveDemandSet(@RequestBody @Validated ScpDemandSetSaveVO saveVO) {
        log.info("[SCP-DEMAND-SET] saveDemandSet  saveVO ={}", (Object)JSONUtil.toJsonStr((Object)saveVO));
        return ApiResult.ok((Object)this.scpDemandOrderSetService.saveDemandSet(saveVO));
    }

    @ApiOperation(value="\u8ba2\u8d27\u96c6 - \u542f\u7528/\u7981\u7528")
    @PostMapping(value={"/change"})
    public ApiResult<Object> changeStatus(@RequestBody @Validated ScpDemandSetStatusParamVO paramVO) {
        log.info("[SCP-DEMAND-SET] changeStatus paramVO = {}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        this.scpDemandOrderSetService.changeDemandSetStatus(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u8ba2\u8d27\u96c6 - \u5220\u9664")
    @PostMapping(value={"/delete"})
    public ApiResult<Object> delete(@RequestBody List<Long> ids) {
        log.info("[SCP-DEMAND-SET] delete ids = {}", (Object)JSONUtil.toJsonStr(ids));
        this.scpDemandOrderSetService.deleteByIds(ids);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u8ba2\u8d27\u96c6 - \u8ba1\u7b97\u5206\u914d")
    @PostMapping(value={"/compute"})
    public ApiResult<Object> compute(@RequestBody List<Long> ids) {
        log.info("[SCP-DEMAND-SET] compute ids = {}", (Object)JSONUtil.toJsonStr(ids));
        this.scpDemandOrderSetService.compute(ids);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u8ba2\u8d27\u96c6 - \u4e0b\u62c9\u7ec4\u4ef6")
    @PostMapping(value={"/list"})
    public ApiResult<List<ScpDemandSetSelectRespVO>> demandSetSearch(@RequestBody ScpDemandSetParamVO paramVO) {
        log.info("[SCP-DEMAND-SET] demandSetSearch  param ={}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        return ApiResult.ok(this.scpDemandOrderSetService.demandSetSelectList(paramVO));
    }

    @ApiOperation(value="\u8ba2\u8d27\u96c6 - \u63a8\u9001")
    @PostMapping(value={"/push"})
    public ApiResult<Object> push(@RequestBody List<Long> ids) {
        log.info("[SCP-DEMAND-SET] push ids = {}", (Object)JSONUtil.toJsonStr(ids));
        this.scpDemandOrderSetService.push(ids);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u8ba2\u8d27\u96c6-  \u5206\u9875\u516c\u5171\u67e5\u8be2")
    @PostMapping(value={"/common/page"})
    public ApiResult<PagingVO<ScpDemandSetPageRespVO>> commonPage(@RequestBody ScpDemandSetPageParamVO paramVO) {
        log.info("[SCP-DEMAND-SET] commonPage  param ={}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok(this.scpDemandOrderSetService.commonPage(paramVO));
    }

    @ApiOperation(value="\u8ba2\u8d27\u96c6-\u5c0f\u7a0b\u5e8f\u5339\u914d\u67e5\u8be2")
    @PostMapping(value={"/common/new/list"})
    public ApiResult<List<ScpDemandSetPageRespVO>> commonNewList(@RequestBody ScpDemandSetPageParamVO paramVO) {
        log.info("[SCP-DEMAND-SET] commonPage  param ={}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok(this.scpDemandOrderSetService.commonNewPage(paramVO));
    }

    public ScpDemandOrderSetController(ScpDemandOrderSetService scpDemandOrderSetService) {
        this.scpDemandOrderSetService = scpDemandOrderSetService;
    }
}

