/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.msg;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.scp.domain.entity.msg.QScpMessageChannelDO;
import com.elitesland.scp.domain.entity.msg.ScpMessageChannelDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class ScpMessageChannelRepoProc
extends BaseRepoProc<ScpMessageChannelDO> {
    private static final QScpMessageChannelDO QDO = QScpMessageChannelDO.scpMessageChannelDO;

    public ScpMessageChannelRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void deleteByMessageId(long messageId) {
        super.deleteByValue(ScpMessageChannelRepoProc.QDO.messageId, (Object)messageId);
    }

    public void deleteByMessageId(@NotEmpty Collection<Long> messageIds) {
        super.deleteByValue(ScpMessageChannelRepoProc.QDO.messageId, messageIds);
    }

    public void deleteChannels(long messageId, @NotEmpty Collection<String> channels) {
        super.delete((Predicate)ScpMessageChannelRepoProc.QDO.messageId.eq((Object)messageId).and((Predicate)ScpMessageChannelRepoProc.QDO.channel.in(channels)));
    }

    public void updatePublishedId(long messageId, String channel, String publishedId) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)ScpMessageChannelRepoProc.QDO.publishedId, (Object)publishedId).where(new Predicate[]{ScpMessageChannelRepoProc.QDO.messageId.eq((Object)messageId).and((Predicate)ScpMessageChannelRepoProc.QDO.channel.eq((Object)channel))}).execute();
    }

    public void deletePublishedId(Collection<Long> messageIds, String channel) {
        this.jpaQueryFactory.update((EntityPath)QDO).setNull((Path)ScpMessageChannelRepoProc.QDO.publishedId).where(new Predicate[]{ScpMessageChannelRepoProc.QDO.messageId.in(messageIds).and((Predicate)ScpMessageChannelRepoProc.QDO.channel.eq((Object)channel))}).execute();
    }

    public List<String> getChannels(long messageId) {
        return super.getValueListByValue((Path)ScpMessageChannelRepoProc.QDO.channel, ScpMessageChannelRepoProc.QDO.messageId, (Object)messageId, new OrderSpecifier[0]);
    }

    public Map<Long, List<String>> getChannels(@NotEmpty Collection<Long> messageIds) {
        return super.getListForGroup(new Expression[]{ScpMessageChannelRepoProc.QDO.messageId, ScpMessageChannelRepoProc.QDO.channel}, (Predicate)ScpMessageChannelRepoProc.QDO.messageId.in(messageIds), t -> (Long)t.get(ScpMessageChannelRepoProc.QDO.messageId), t -> (String)t.get((Expression)ScpMessageChannelRepoProc.QDO.channel));
    }

    public Map<Long, String> getPublishedId(@NotEmpty Collection<Long> messageIds, @NotBlank String channel) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{ScpMessageChannelRepoProc.QDO.messageId, ScpMessageChannelRepoProc.QDO.publishedId}).from((EntityPath)QDO)).where((Predicate)ScpMessageChannelRepoProc.QDO.messageId.in(messageIds).and((Predicate)ScpMessageChannelRepoProc.QDO.channel.eq((Object)channel)))).fetch().stream().filter(t -> StringUtils.hasText((String)((String)t.get((Expression)ScpMessageChannelRepoProc.QDO.publishedId)))).collect(Collectors.toMap(t -> (Long)t.get(ScpMessageChannelRepoProc.QDO.messageId), t -> (String)t.get((Expression)ScpMessageChannelRepoProc.QDO.publishedId)));
    }
}

