/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.lakalapay.service;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitesland.inv.dto.invTro.InvTroOnlinePayRpcDTO;
import com.elitesland.pur.dto.po.PurPoOnlinePayRpcDTO;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderUpdatePayStatusMqParam;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountRepoProc;
import com.elitesland.scp.lakalapay.service.LklPaymentService;
import com.elitesland.scp.lakalapay.utils.TcslPay;
import com.elitesland.scp.lakalapay.vo.BalanceResponseVO;
import com.elitesland.scp.lakalapay.vo.OnlineLklPayOrderParamVO;
import com.elitesland.scp.lakalapay.vo.OnlineLolPayOrderResponseVO;
import com.elitesland.scp.lakalapay.vo.QueryAccountDtlParamVO;
import com.elitesland.scp.lakalapay.vo.QueryBalanceParamVO;
import com.elitesland.scp.pay.config.EntpayProperties;
import com.elitesland.scp.pay.service.AccountLinkService;
import com.elitesland.scp.pay.service.NotifyVerifyService;
import com.elitesland.scp.pay.vo.PayOrderReqDTO;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiPurRpcService;
import com.elitesland.scp.utils.MessageDelyQueueService;
import com.elitesland.support.provider.org.dto.OrgBankRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuBankRpcDTO;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.tenpay.business.entpay.mse.sdk.common.NotifyHandler;
import com.tenpay.business.entpay.mse.sdk.config.EntpayConfig;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import com.tenpay.business.entpay.mse.sdk.model.FrontCallbackUrl;
import com.tenpay.business.entpay.mse.sdk.model.Goods;
import com.tenpay.business.entpay.mse.sdk.model.PayerInfo;
import com.tenpay.business.entpay.mse.sdk.model.PaymentMpParam;
import com.tenpay.business.entpay.mse.sdk.model.PaymentNotifyModel;
import com.tenpay.business.entpay.mse.sdk.model.PaymentNotifyUrl;
import com.tenpay.business.entpay.mse.sdk.model.PaymentParam;
import com.tenpay.business.entpay.mse.sdk.model.PaymentPayee;
import com.tenpay.business.entpay.mse.sdk.model.PaymentQRParam;
import com.tenpay.business.entpay.mse.sdk.model.PaymentRiskControl;
import com.tenpay.business.entpay.mse.sdk.model.SceneInfo;
import com.tenpay.business.entpay.mse.sdk.model.StoreInfo;
import java.io.Serializable;
import java.math.RoundingMode;
import java.security.PublicKey;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class LklPaymentServiceImpl
implements LklPaymentService {
    private static final Logger log = LoggerFactory.getLogger(LklPaymentServiceImpl.class);
    private final NotifyVerifyService notifyVerifyService;
    private final RedisWrapper redisWrapper;
    private final RedisUtils redisUtils;
    private final RmiPurRpcService rmiPurRpcService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final AccountLinkService accountLinkService;
    private final MessageQueueTemplate messageQueueTemplate;
    private final ScpWqfEntAccountRepoProc scpWqfEntAccountRepoProc;
    private final MessageDelyQueueService messageDelyQueueService;
    private final OrgStoreRpcService orgStoreRpcService;
    private final OrgOuRpcService orgOuRpcService;

    @Override
    public OnlineLolPayOrderResponseVO createMpPayOnline(OnlineLklPayOrderParamVO param) {
        try {
            String docCls = param.getDocNo().substring(0, 2);
            String docNo = param.getDocNo();
            OnlineLolPayOrderResponseVO onlineLolPayOrderResponseVO = this.buildPayItems(param, docCls);
            if (onlineLolPayOrderResponseVO != null) {
                return onlineLolPayOrderResponseVO;
            }
            this.buildPaymentMapParam(param);
            OnlineLolPayOrderResponseVO pay = TcslPay.pay(param);
            if (pay == null || pay.getPayUrl() == null) {
                throw new BusinessException("\u83b7\u53d6\u652f\u4ed8\u94fe\u63a5\u5931\u8d25");
            }
            ScpOrderUpdatePayStatusMqParam updateParamVO = new ScpOrderUpdatePayStatusMqParam();
            updateParamVO.setBusinessKey("scp_order_update_pay_status");
            updateParamVO.setDocNo(param.getDocNo());
            updateParamVO.setPaymentId(pay.getTradeNo());
            updateParamVO.setAmt(param.getAmt());
            updateParamVO.setPayerName(param.getPayerName());
            updateParamVO.setDocCls(docCls);
            this.messageQueueTemplate.publishMessageSync("yst-suplan", "scp_order_update_pay_status", (Serializable)updateParamVO);
            this.redisUtils.set("SCP_ONLINE_PAY:" + docNo, (Object)JSONUtil.toJsonStr((Object)pay.getPayUrl()), 25L, TimeUnit.HOURS);
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime expireTime = now.plusDays(1L);
            Duration duration = Duration.between(now, expireTime);
            this.messageDelyQueueService.resettingOrderExpireTime("SCP_ONLINE_PAY:" + docNo, duration.toMillis());
            return pay;
        }
        catch (Exception e) {
            throw new BusinessException("\u62c9\u5361\u62c9\u652f\u4ed8\u5931\u8d25" + e.getMessage());
        }
    }

    @Override
    public BalanceResponseVO queryBalance(QueryBalanceParamVO param) {
        try {
            return TcslPay.queryBalance(param);
        }
        catch (Exception e) {
            throw new BusinessException("\u62c9\u5361\u62c9\u4f59\u989d\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
    }

    @Override
    public String queryAccountDtl(QueryAccountDtlParamVO param) {
        try {
            return TcslPay.queryAccountDtl(param);
        }
        catch (Exception e) {
            throw new BusinessException("\u62c9\u5361\u62c9\u8d22\u52a1\u660e\u7ec6\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
    }

    private OnlineLolPayOrderResponseVO buildPayItems(OnlineLklPayOrderParamVO param, String docCls) {
        OnlineLolPayOrderResponseVO onlineLolPayOrderResponseVO = new OnlineLolPayOrderResponseVO();
        Object obj = this.redisUtils.get("SCP_ONLINE_PAY:" + param.getDocNo());
        OnlineLklPayOrderParamVO.PayeeInfoVO payeeInfoVO = new OnlineLklPayOrderParamVO.PayeeInfoVO();
        payeeInfoVO.setSubTradeAmount("" + param.getAmt().setScale(2, RoundingMode.HALF_UP));
        List ouBank = this.orgOuRpcService.findOuBank(param.getOuId());
        if (ouBank == null || ouBank.isEmpty()) {
            throw new BusinessException("\u9500\u552e\u65b9\u672a\u7ed1\u5b9a\u94f6\u884c\u5361");
        }
        Optional<OrgOuBankRpcDTO> in = ouBank.stream().filter(a -> a.getAccType().equals("IN")).findAny();
        if (in.isEmpty()) {
            throw new BusinessException("\u9500\u552e\u65b9\u672a\u7ed1\u5b9a\u94f6\u884c\u5361");
        }
        OrgOuBankRpcDTO orgOuBankRpcDTO = in.get();
        payeeInfoVO.setPayeeAccountNo(orgOuBankRpcDTO.getBankAcc());
        payeeInfoVO.setPayeeName(orgOuBankRpcDTO.getHolderName());
        payeeInfoVO.setSubOutTradeNo(param.getDocNo());
        param.setPayeeInfo(List.of(payeeInfoVO));
        if ("PO".equals(docCls)) {
            PurPoOnlinePayRpcDTO onlinePayInfo = this.rmiPurRpcService.findOnlinePayInfo(param.getDocId());
            if (onlinePayInfo == null) {
                throw new BusinessException("\u652f\u4ed8\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            if (onlinePayInfo.getOnlinePayFlag().booleanValue()) {
                throw new BusinessException("\u8ba2\u5355\u5df2\u652f\u4ed8");
            }
            if (obj != null && !onlinePayInfo.getOnlinePayFlag().booleanValue()) {
                String url = (String)JSON.parseObject((String)((String)obj), String.class);
                onlineLolPayOrderResponseVO.setPayUrl(url);
                return onlineLolPayOrderResponseVO;
            }
        } else {
            InvTroOnlinePayRpcDTO onlinePayInfo = this.rmiInvStkRpcService.findOnlinePayInfo(param.getDocId());
            if (onlinePayInfo == null) {
                throw new BusinessException("\u652f\u4ed8\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            if (onlinePayInfo.getOnlinePayFlag().booleanValue()) {
                throw new BusinessException("\u8ba2\u5355\u5df2\u652f\u4ed8");
            }
            if (obj != null && !onlinePayInfo.getOnlinePayFlag().booleanValue()) {
                String url = (String)JSON.parseObject((String)((String)obj), String.class);
                onlineLolPayOrderResponseVO.setPayUrl(url);
                return onlineLolPayOrderResponseVO;
            }
        }
        return null;
    }

    private void buildPaymentMapParam(OnlineLklPayOrderParamVO param) {
        List bankByStoreCode = this.orgStoreRpcService.findBankByStoreCode(param.getStoreCode());
        if (bankByStoreCode == null || bankByStoreCode.isEmpty()) {
            throw new BusinessException("\u95e8\u5e97[" + param.getStoreCode() + "]\u672a\u7ed1\u5b9a\u94f6\u884c\u4fe1\u606f");
        }
        Optional<OrgBankRpcDTO> orgBankRpcDTO = bankByStoreCode.stream().filter(bank -> bank.getOpenBank().equals("\u62c9\u5361\u62c9")).findAny();
        if (orgBankRpcDTO.isEmpty()) {
            throw new BusinessException("\u95e8\u5e97[" + param.getStoreCode() + "]\u672a\u7ed1\u5b9a\u62c9\u5361\u62c9\u94f6\u884c\u4fe1\u606f");
        }
        OrgBankRpcDTO orgBankRpcDTO1 = orgBankRpcDTO.get();
        param.setPayerName(orgBankRpcDTO1.getName());
        param.setPayerNo(orgBankRpcDTO1.getCardNo());
        param.setPayerType(orgBankRpcDTO1.getType());
    }

    @Override
    public String paymentNotify(String body, String authorization) throws EntpayException, JSONException {
        PaymentNotifyModel model = (PaymentNotifyModel)NotifyHandler.handlerWebhook((String)body, (String)authorization, PaymentNotifyModel.class, (PublicKey)EntpayConfig.getRealTbepPublicKey(null));
        log.info("\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u6570\u636e\uff1a{}", (Object)JSONUtil.toJsonStr((Object)model));
        this.notifyVerifyService.processNotify(model);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("retcode", 0);
        jsonObject.put("retmsg", (Object)"SUCCESS");
        return jsonObject.toString();
    }

    private PaymentQRParam constructQRPaymentParam(PayOrderReqDTO param) {
        PaymentQRParam paymentQRParam = new PaymentQRParam();
        BeanUtils.copyProperties((Object)this.constructCommonParam(param), (Object)paymentQRParam);
        Object o = this.redisWrapper.apply(() -> this.redisUtils.get("ENT_PAY_PROPERTIES"), null);
        if (o == null) {
            throw new BusinessException("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5fae\u4f01\u4ed8\u4fe1\u606f");
        }
        EntpayProperties entpayProperties = (EntpayProperties)JSONUtil.toBean((String)o.toString(), EntpayProperties.class);
        PaymentNotifyUrl paymentNotifyUrl = PaymentNotifyUrl.builder().serverNotifyUrl(entpayProperties.getServerNotifyUrl()).build();
        paymentQRParam.setNotifyUrl(paymentNotifyUrl);
        return paymentQRParam;
    }

    private PaymentMpParam constructMPPaymentParam(PayOrderReqDTO param) {
        PaymentMpParam paymentMpParam = new PaymentMpParam();
        BeanUtils.copyProperties((Object)this.constructCommonParam(param), (Object)paymentMpParam);
        Object o = this.redisWrapper.apply(() -> this.redisUtils.get("ENT_PAY_PROPERTIES"), null);
        if (o == null) {
            throw new BusinessException("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5fae\u4f01\u4ed8\u4fe1\u606f");
        }
        EntpayProperties entpayProperties = (EntpayProperties)JSONUtil.toBean((String)o.toString(), EntpayProperties.class);
        FrontCallbackUrl frontCallbackUrl = FrontCallbackUrl.builder().mpAppid(entpayProperties.getMpAppid()).mpUsername(entpayProperties.getMpUsername()).mpPath(param.getMpPath()).build();
        PaymentNotifyUrl paymentNotifyUrl = PaymentNotifyUrl.builder().serverNotifyUrl(entpayProperties.getServerNotifyUrl()).frontCallbackUrl(frontCallbackUrl).build();
        paymentMpParam.setNotifyUrl(paymentNotifyUrl);
        return paymentMpParam;
    }

    private PaymentParam constructCommonParam(PayOrderReqDTO param) {
        PaymentPayee payee = PaymentPayee.builder().entId(param.getEntId()).entName(param.getEntName()).entAcctId(param.getEntAccId()).bankAccountNumberLast4(param.getBankAccountLast4()).build();
        List<Goods> goodsList = param.getGoods();
        PaymentRiskControl paymentRiskControl = PaymentRiskControl.builder().deviceId(param.getDeviceId()).payerClientIp(param.getPayerClientIp()).payerUa(param.getPayerUa()).createTime(param.getCreateTime()).pickType(param.getPickType()).pickDescription(param.getPickDescription()).build();
        StoreInfo storeInfo = StoreInfo.builder().id(param.getStoreId()).name(param.getStoreName()).areaCode(param.getStoreAreaCode()).build();
        SceneInfo sceneInfo = SceneInfo.builder().storeInfo(storeInfo).build();
        ArrayList<PayerInfo> payerOptions = new ArrayList<PayerInfo>();
        PayerInfo payerInfo = PayerInfo.builder().payerName(param.getPayerName()).assignPayType(param.getPayerType()).build();
        payerOptions.add(payerInfo);
        return PaymentParam.builder().outPaymentId(param.getOutPaymentId()).amount(param.getAmount()).currency(param.getCurrency()).expireTime(param.getExpireTime()).payee(payee).goods(goodsList).memo(param.getMemo()).attachment(param.getAttachment()).riskControl(paymentRiskControl).sceneInfo(sceneInfo).profitAllocationFlag(param.getProfitAllocationFlag()).payerOptions(payerOptions).build();
    }

    public LklPaymentServiceImpl(NotifyVerifyService notifyVerifyService, RedisWrapper redisWrapper, RedisUtils redisUtils, RmiPurRpcService rmiPurRpcService, RmiInvStkRpcService rmiInvStkRpcService, AccountLinkService accountLinkService, MessageQueueTemplate messageQueueTemplate, ScpWqfEntAccountRepoProc scpWqfEntAccountRepoProc, MessageDelyQueueService messageDelyQueueService, OrgStoreRpcService orgStoreRpcService, OrgOuRpcService orgOuRpcService) {
        this.notifyVerifyService = notifyVerifyService;
        this.redisWrapper = redisWrapper;
        this.redisUtils = redisUtils;
        this.rmiPurRpcService = rmiPurRpcService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.accountLinkService = accountLinkService;
        this.messageQueueTemplate = messageQueueTemplate;
        this.scpWqfEntAccountRepoProc = scpWqfEntAccountRepoProc;
        this.messageDelyQueueService = messageDelyQueueService;
        this.orgStoreRpcService = orgStoreRpcService;
        this.orgOuRpcService = orgOuRpcService;
    }
}

