/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.pay.config;

import cn.hutool.json.JSONUtil;
import com.elitesland.scp.pay.config.EntpayProperties;
import com.tenpay.business.entpay.mse.sdk.config.EntpayConfig;
import com.tenpay.business.entpay.mse.sdk.enums.EnvironmentEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@ConditionalOnProperty(prefix="entpay", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={EntpayProperties.class})
public class EntpaySdkConfig
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(EntpaySdkConfig.class);
    private final EntpayProperties properties;
    private final RedisTemplate redisTemplate;

    public EntpaySdkConfig(EntpayProperties properties, RedisTemplate redisTemplate) {
        log.info("EntpaySdkConfig\uff1a{}", (Object)JSONUtil.toJsonStr((Object)properties));
        this.properties = properties;
        this.redisTemplate = redisTemplate;
    }

    public void afterPropertiesSet() throws Exception {
        log.info("begin init entpay config...");
        EntpayConfig.setNormalMode((String)this.properties.getPlatformId(), (String)this.properties.getPlatformPrivateKey(), (String)this.properties.getPlatformPrivateCertSerialNo(), (String)this.properties.getTbepSerialNo(), (String)this.properties.getTbepPublicKey());
        if ("PRO".equals(this.properties.getEnv())) {
            EntpayConfig.setEnv((EnvironmentEnum)EnvironmentEnum.PRO);
        } else {
            EntpayConfig.setEnv((EnvironmentEnum)EnvironmentEnum.SANDBOX);
        }
        this.redisTemplate.opsForValue().set((Object)"ENT_PAY_PROPERTIES", (Object)JSONUtil.toJsonStr((Object)this.properties));
        EntpayConfig.setConnectionRequestTimeout((int)3000);
        EntpayConfig.setConnectTimeout((int)5000);
        EntpayConfig.setSocketTimeout((int)15000);
        log.info("init entpay config done");
    }
}

