/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.utils;

import com.alibaba.fastjson.JSON;
import com.elitesland.scp.domain.entity.collect.ScpUserCollectDO;
import com.elitesland.scp.utils.SysUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class CollectRedisUtil {
    private static final Logger log = LoggerFactory.getLogger(CollectRedisUtil.class);
    private final RedisTemplate redisClient;

    public BoundHashOperations<String, Object, Object> getUserCollectOps(String storeCode, Long userId) {
        String cartKey = "SCP:COLLECT:" + userId + ":" + storeCode;
        return this.redisClient.boundHashOps((Object)cartKey);
    }

    public List<ScpUserCollectDO> getUserCollectItems(String storeCode, Long userId) {
        BoundHashOperations<String, Object, Object> operations = this.getUserCollectOps(storeCode, userId);
        return ((List)Optional.ofNullable(operations.values()).orElse(new ArrayList())).stream().map(obj -> {
            String str = (String)obj;
            return JSON.parseArray((String)str, ScpUserCollectDO.class);
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Boolean existsSpuInUser(String storeCode, Long userId, String itemKey) {
        BoundHashOperations<String, Object, Object> operations = this.getUserCollectOps(storeCode, userId);
        Object obj = operations.get((Object)SysUtils.generateRedisKey("SPU", itemKey));
        return obj != null;
    }

    public CollectRedisUtil(RedisTemplate redisClient) {
        this.redisClient = redisClient;
    }
}

