package com.elitesland.scp.lakalapay.service;


import com.elitesland.scp.lakalapay.vo.*;
import com.elitesland.scp.pay.vo.OnlinePayOrderParamVO;
import com.tenpay.business.entpay.mse.sdk.api.Redirect;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import org.springframework.boot.configurationprocessor.json.JSONException;

public interface LklPaymentService {

    /**
     * 小程序支付下单-在线
     *
     * @return
     */
    OnlineLolPayOrderResponseVO createMpPayOnline(OnlineLklPayOrderParamVO param);

    /**
     * 查询余额
     *
     * @param param
     * @return
     */
    BalanceResponseVO queryBalance(QueryBalanceParamVO param);

    String queryAccountDtl(QueryAccountDtlParamVO param);

    /**
     * 支付回调
     *
     * @param body
     * @param authorization
     * @return
     */
    String paymentNotify(String body, String authorization) throws EntpayException, JSONException;

}
