package com.elitesland.scp.lakalapay.utils;

import com.alibaba.fastjson.JSONObject;
import com.elitesland.scp.lakalapay.vo.OnlineLklPayOrderParamVO;
import com.elitesland.scp.lakalapay.vo.OnlineLolPayOrderResponseVO;
import com.elitesland.scp.lakalapay.vo.OnlineLolPayOrderResultResponseVO;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import org.apache.commons.codec.binary.Base64;

/**
 * 用来请求商龙开放平台接口的deme，前提引入httpClient依赖包
 * org.apache.httpcomponents
 * httpclient
 * 4.5.13
 */

public class TcslSylDemo {
    private static final Logger log = LoggerFactory.getLogger(TcslSylDemo.class);
    // 商龙开放平台接口访问地址,例如 测试环境：http://open-test.tcsl.com.cn/api/，
// 线上环境：https://openapi.tcsl.com.cn/
        static String host = "http://open-test.tcsl.com.cn/api/";
//    static String host = "https://openapi.tcsl.com.cn/";

    // 接口名，从商龙开放平台获取,例如 sly/newProxy/openapi/api/v1/item/type/create
    static String methodName = "yzj/wuuxiangcloudfunds/third/external/payment/checkoutPay";//替换成开放平台接口文档里对应的接口名称
    //开放平台业务接口，目前只支持HTTP POST一种请求方式
//指定Body Content-Type为：application/x-www-form-urlencoded或者application/json
//Post请求时，所有参数均通过表单传递，请勿将请求参数放到Query参数中。
    static String appSecret = "761wgubwjzc5652ncjm9xi08b9wk2wq3";//你的appSecret，注意替换
    static String appKey = "x02nsum1p2tgfarqwee85rea7ri7fnpl";
    static String groupID = "G301705";

    public static void main(String[] args) {

        //参数1：头参数
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("groupID", groupID); //集团id，不可为空，G号不要写错了
        headerMap.put("traceID", UUID.randomUUID().toString());//业务方的traceID，问题排查时，提供该traceID,你自己生成一个唯一ID就行
        headerMap.put("Proxy-Client-IP", "192.168.131.179");//请传入真实IP，用于校验ip白名单


        //参数2：系统级必传参数，每个接口必传这几个值，签名算法中会用到，不能缺少
        Map<String, String> systemParamsMap = new HashMap<>();
        systemParamsMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        systemParamsMap.put("appKey", appKey);
        systemParamsMap.put("version", "1");//固定值1
        systemParamsMap.put("charset", "UTF-8");//固定值UTF-8
        //参数类型3：业务查询参数
        Map<String, String> bizParamsMap = new HashMap<>();
//        bizParamsMap.put("biz", "{\"mcId\":4991}");//这里放你的报文，注意json压缩格式化

        Map<String, String> paramsMap = new HashMap<>();
        Map<String, String> sonParamsMap = new HashMap<>();
//        channelCode	渠道编码		是	string	 LklSmb-拉卡拉全渠道（苏商）,上送 LklSmb
//        outTradeNo	商户交易单号	是	string	必须唯一，长度限制：60
//        outTradeTime	商户交易日期时间	是	string	时间格式：yyyy-MM-dd HH:mm:ss
//        payerAccountNo	付款方账号	是	string	付款方账户号
//        payerName	付款方名称	否	string	付款方账户名称
//        postscript		银行附言	否	string	长度限制100字符
//        remark	备注	否	string	长度限制100字符
//        transFeeTakeFlag	手续费承担方标识	否	string
//        payExpireTime	支付过期时间	否	string	时间格式：yyyy-MM-dd HH:mm:ss 暂时无用，不传
//        body	商品名称	否	string	长度限制100字符
//        dcCode	收支编码	否	string
//        outBussNo	外部系统业务单号	否	string	外部系统业务单号
        bizParamsMap.put("channelCode", "LklSmb");
        bizParamsMap.put("outTradeNo", "");
        bizParamsMap.put("outTradeTime", "2021-05-01 09:00:00");
        bizParamsMap.put("payerAccountNo", "");
        bizParamsMap.put("payerName", "");
        bizParamsMap.put("postscript", "");
        bizParamsMap.put("remark", "");
        bizParamsMap.put("transFeeTakeFlag", "");
        bizParamsMap.put("payExpireTime", "");
        bizParamsMap.put("body", "");
        bizParamsMap.put("dcCode", "");
        bizParamsMap.put("outBussNo", "");
        //        payeeName	收款方名称	否	string	子单收款方账户名称
//        payeeAccountNo	收款方账号	是	string	子单收款方账户号（目前拉卡拉全渠道交易只支持所有的子单收款方账户号必须一样，不支持不支持不同的收款方账户交易）
//        subOutTradeNo	子单商户交易单号	是	string	子订单商户流水号
//        subTradeAmount	子交易金额	是	string	子单交易金额，保留两位小数，单位:元
//        body	商品名称	否	string	子单商品名称
//        payeeFreezeFlag	冻结标识 	否	string	Y-冻结 N-不冻结
        sonParamsMap.put("payeeName", "");
        sonParamsMap.put("payeeAccountNo", "");
        sonParamsMap.put("subOutTradeNo", "");
        sonParamsMap.put("subTradeAmount", "");
        sonParamsMap.put("body", "");
        bizParamsMap.put("payeeFreezeFlag", "");
        bizParamsMap.put("payeeList", JSONObject.toJSONString(sonParamsMap));
        paramsMap.put("biz", JSONObject.toJSONString(bizParamsMap));

        try {
            //生成用来签名的完整url路径
            String urlForGenSig = genUrlForGenSig(host, methodName, systemParamsMap, bizParamsMap);
            //生成签名
            String sig = getSig(appSecret, urlForGenSig);
            //发送请求
            String response = sendRequest(urlForGenSig, sig, headerMap, bizParamsMap);
            // 输出响应响应体
            System.out.println("Response Body : " + response);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static OnlineLolPayOrderResponseVO pay(OnlineLklPayOrderParamVO payOrderParamVO) {

        //参数1：头参数
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("groupID", groupID); //集团id，不可为空，G号不要写错了
        headerMap.put("traceID", UUID.randomUUID().toString());//业务方的traceID，问题排查时，提供该traceID,你自己生成一个唯一ID就行
        headerMap.put("Proxy-Client-IP", "192.168.131.179");//请传入真实IP，用于校验ip白名单


        //参数2：系统级必传参数，每个接口必传这几个值，签名算法中会用到，不能缺少
        Map<String, String> systemParamsMap = new HashMap<>();
        systemParamsMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        systemParamsMap.put("appKey", appKey);
        systemParamsMap.put("version", "1");//固定值1
        systemParamsMap.put("charset", "UTF-8");//固定值UTF-8
        //参数类型3：业务查询参数
        Map<String, String> bizParamsMap = new HashMap<>();
//        bizParamsMap.put("biz", "{\"mcId\":4991}");//这里放你的报文，注意json压缩格式化

        Map<String, String> paramsMap = new HashMap<>();
        Map<String, String> sonParamsMap = new HashMap<>();
//        channelCode	渠道编码		是	string	 LklSmb-拉卡拉全渠道（苏商）,上送 LklSmb
//        outTradeNo	商户交易单号	是	string	必须唯一，长度限制：60
//        outTradeTime	商户交易日期时间	是	string	时间格式：yyyy-MM-dd HH:mm:ss
//        payerAccountNo	付款方账号	是	string	付款方账户号
//        payerName	付款方名称	否	string	付款方账户名称
//        postscript		银行附言	否	string	长度限制100字符
//        remark	备注	否	string	长度限制100字符
//        transFeeTakeFlag	手续费承担方标识	否	string
//        payExpireTime	支付过期时间	否	string	时间格式：yyyy-MM-dd HH:mm:ss 暂时无用，不传
//        body	商品名称	否	string	长度限制100字符
//        dcCode	收支编码	否	string
//        outBussNo	外部系统业务单号	否	string	外部系统业务单号
        paramsMap.put("channelCode", "LklSmb");
        paramsMap.put("outTradeNo", payOrderParamVO.getDocNo());
        paramsMap.put("outTradeTime", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        paramsMap.put("payerAccountNo", "");
        paramsMap.put("payerName", "");
        paramsMap.put("postscript", "");
        paramsMap.put("remark", payOrderParamVO.getRemark());
        paramsMap.put("transFeeTakeFlag", "");
        paramsMap.put("payExpireTime", "");
        paramsMap.put("body", "");
        paramsMap.put("dcCode", "");
        paramsMap.put("outBussNo", "");
        //        payeeName	收款方名称	否	string	子单收款方账户名称
//        payeeAccountNo	收款方账号	是	string	子单收款方账户号（目前拉卡拉全渠道交易只支持所有的子单收款方账户号必须一样，不支持不支持不同的收款方账户交易）
//        subOutTradeNo	子单商户交易单号	是	string	子订单商户流水号
//        subTradeAmount	子交易金额	是	string	子单交易金额，保留两位小数，单位:元
//        body	商品名称	否	string	子单商品名称
//        payeeFreezeFlag	冻结标识 	否	string	Y-冻结 N-不冻结
        sonParamsMap.put("payeeName", "");
        sonParamsMap.put("payeeAccountNo", "");
        sonParamsMap.put("subOutTradeNo", "");
        sonParamsMap.put("subTradeAmount", "");
        sonParamsMap.put("body", "");
        paramsMap.put("payeeFreezeFlag", "");
        paramsMap.put("payeeList", JSONObject.toJSONString(sonParamsMap));
        bizParamsMap.put("biz", JSONObject.toJSONString(paramsMap));

        try {
            //生成用来签名的完整url路径
            String urlForGenSig = genUrlForGenSig(host, methodName, systemParamsMap, bizParamsMap);
            //生成签名
            String sig = getSig(appSecret, urlForGenSig);
            //发送请求
            String response = sendRequest(urlForGenSig, sig, headerMap, bizParamsMap);
            // 输出响应响应体
            log.info("Response Body : " + response);
            JSONObject jsonObject = JSONObject.parseObject(response);
            JSONObject jsonObject1 = jsonObject.getJSONObject("data");
            OnlineLolPayOrderResponseVO onlineLolPayOrderResponseVO = JSONObject.parseObject(response, OnlineLolPayOrderResponseVO.class);

            return onlineLolPayOrderResponseVO;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

    }

    public static OnlineLolPayOrderResultResponseVO getPayResult(OnlineLklPayOrderParamVO payOrderParamVO) {

        //参数1：头参数
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("groupID", groupID); //集团id，不可为空，G号不要写错了
        headerMap.put("traceID", UUID.randomUUID().toString());//业务方的traceID，问题排查时，提供该traceID,你自己生成一个唯一ID就行
        headerMap.put("Proxy-Client-IP", "192.168.131.179");//请传入真实IP，用于校验ip白名单


        //参数2：系统级必传参数，每个接口必传这几个值，签名算法中会用到，不能缺少
        Map<String, String> systemParamsMap = new HashMap<>();
        systemParamsMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        systemParamsMap.put("appKey", appKey);
        systemParamsMap.put("version", "1");//固定值1
        systemParamsMap.put("charset", "UTF-8");//固定值UTF-8
        //参数类型3：业务查询参数
        Map<String, String> bizParamsMap = new HashMap<>();
        Map<String, String> paramsMap = new HashMap<>();
        paramsMap.put("outTradeNo", payOrderParamVO.getDocNo());
        bizParamsMap.put("biz", JSONObject.toJSONString(paramsMap));

        try {
            //生成用来签名的完整url路径
            String urlForGenSig = genUrlForGenSig(host, methodName, systemParamsMap, bizParamsMap);
            //生成签名
            String sig = getSig(appSecret, urlForGenSig);
            //发送请求
            String response = sendRequest(urlForGenSig, sig, headerMap, bizParamsMap);
            // 输出响应响应体
            System.out.println("Response Body : " + response);
            JSONObject jsonObject = JSONObject.parseObject(response);
            JSONObject jsonObject1 = jsonObject.getJSONObject("data");
            OnlineLolPayOrderResultResponseVO onlineLolPayOrderResponseVO = JSONObject.parseObject(response, OnlineLolPayOrderResultResponseVO.class);

            return onlineLolPayOrderResponseVO;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

    }

    private static String sendRequest(String url, String sig, Map<String, String> headersMap, Map<String, String> paramsMap)
            throws RuntimeException {
        String requestUrl = url + "&sig=" + sig;
        HttpPost httpPost = new HttpPost(requestUrl);
        CloseableHttpResponse response = null;
        try {
            //设置参数
// List nameValuePairList = convertToEntity(paramsMap);
// UrlEncodedFormEntity uefEntity = new UrlEncodedFormEntity(nameValuePairList, "UTF-8");
// httpPost.setEntity(uefEntity);
            headersMap.forEach((k, v) -> httpPost.addHeader(k, v));
            CloseableHttpClient httpClient = HttpClients.createDefault();
// 设置请求头
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("Accept", "application/json");

            // 设置请求体
            String requestBody = paramsMap.get("biz");
            httpPost.setEntity(new StringEntity(requestBody, StandardCharsets.UTF_8));
            response = httpClient.execute(httpPost);
            HttpEntity entity = response.getEntity();
            return EntityUtils.toString(entity, "UTF-8");

        } catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        } finally {
            httpPost.releaseConnection();
            try {
                if (response != null) {
                    response.close();
                }
            } catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

    }

    public static String getSig(String appSecret, String baseUrl) {
        try {
            Mac hs256 = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(appSecret.getBytes("UTF-8"), "HmacSHA256");
            hs256.init(secretKey);
            byte[] bytes = hs256.doFinal(baseUrl.getBytes("UTF-8"));

            return toHex(bytes);
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("不支持HmacSHA256算法", e);
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("不支持utf8编码", e);
        } catch (Exception e) {
            throw new RuntimeException("hs256签名失败", e);
        }

    }

    public static String toHex(byte[] bytes) {
        StringBuffer hexstr = new StringBuffer();
        for (int i = 0; i < bytes.length; i++) {
            String b = Integer.toHexString(bytes[i] & 0xFF);
            if (b.length() < 2) {
                hexstr.append(0);
            }
            hexstr.append(b);
        }

        return hexstr.toString();
    }

    public static String genUrlForGenSig(String host, String methodName, Map<String, String> systemParamsMap,
                                         Map<String, String> applicationParamsMap) throws UnsupportedEncodingException {
        Map<String, String> paramMap = new HashMap<>();
        paramMap.putAll(systemParamsMap);
        //如果应用级参数不为空，则组合应用级参数
        if (applicationParamsMap != null) {
            paramMap.putAll(applicationParamsMap);
        }
        return host + methodName + "?" + getSortedParamStr(paramMap);
    }

    /**
     * 构造自然排序请求参数
     *
     * @param params 请求
     * @return 字符串
     */
    public static String getSortedParamStr(Map<String, String> params) throws UnsupportedEncodingException {
        Set<String> sortedParams = new TreeSet<>(params.keySet());
        StringBuilder sortedParamStr = new StringBuilder();
        for (String key : sortedParams) {
            String value = params.get(key);
            // 排除sign
            if (null != value && !"".equals(value) && !"sig".equalsIgnoreCase(key) && !"biz".equalsIgnoreCase(key)) {
                sortedParamStr.append(key + "=" + URLEncoder.encode(value, "UTF-8") + "&");
            }
        }
        return sortedParamStr.substring(0, sortedParamStr.length() - 1);
    }

    /**
     * 对象转化为参数列表
     *
     * @param applicationParamsMap
     * @return
     */
    public static List<BasicNameValuePair> convertToEntity(Map<String, String> applicationParamsMap)
            throws RuntimeException {
        List<BasicNameValuePair> formParam = new ArrayList<>();
        try {
            if (applicationParamsMap != null) {
                for (Map.Entry<String, String> entry : applicationParamsMap.entrySet()) {
                    BasicNameValuePair nameValuePair = new BasicNameValuePair(entry.getKey(), entry.getValue());
                    formParam.add(nameValuePair);
                }
            }
        } catch (Exception e) {
            throw new RuntimeException("1");
        }
        return formParam;
    }
}