package com.elitesland.scp.lakalapay.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel("账号查询参数")
public class QueryBalanceParamVO implements Serializable {
    private static final long serialVersionUID = 6074350548106028859L;

    @ApiModelProperty(value = "品牌编号", required = true)
    @NotNull(message = "品牌编号不能为空")
    private Long brandId;

    @ApiModelProperty(value = "账户编号", required = true)
    @NotBlank(message = "账户编号不能为空")
    private String accountNo;


}
