/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.calendar;

import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpSuppDemandCalendarPageParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpSuppDemandCalendarPageVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpSuppDemandCalendarParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpSuppDemandCalendarRespVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpSuppDemandCalendarSaveVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.service.calendar.ScpSuppDemandCalendarService;
import com.elitesland.scp.application.service.scpsman.BaseScpmanAuthorityParam;
import com.elitesland.scp.domain.convert.calendar.ScpSuppDemandCalendarConvert;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.domain.service.calendar.ScpSuppDemandCalendarDomainService;
import com.elitesland.scp.infr.dto.calendar.ScpSuppDemandCalendarDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpSuppDemandCalendarServiceImpl
implements ScpSuppDemandCalendarService {
    private static final Logger log = LoggerFactory.getLogger(ScpSuppDemandCalendarServiceImpl.class);
    private final ScpSuppDemandCalendarDomainService scpSuppCalendarDomainService;
    private final ScpDemandAuthorityService scpDemandAuthorityService;

    @Override
    public PagingVO<ScpSuppDemandCalendarPageVO> searchPage(ScpSuppDemandCalendarPageParamVO param) {
        List<String> businessKey;
        List<ScpSuppDemandCalendarDTO> dtos;
        PagingVO<ScpSuppDemandCalendarPageVO> paging;
        if (Boolean.TRUE.equals(param.getScpmanAuthority())) {
            PagingVO<ScpManAuthorityPageRespVO> userAuthority = this.scpDemandAuthorityService.getCurrentUserAuthority();
            if (userAuthority.isEmpty()) {
                return PagingVO.builder().total(0L).records(new ArrayList()).build();
            }
            this.extractedAuthorityParam(param, userAuthority);
        }
        if (CollectionUtils.isNotEmpty((Collection)(paging = this.scpSuppCalendarDomainService.searchPage(param)).getRecords()) && CollectionUtils.isNotEmpty(dtos = this.scpSuppCalendarDomainService.findCalendarListByConcatStr(businessKey = paging.getRecords().stream().map(this::getBusinessString).collect(Collectors.toList())))) {
            Map<String, List<ScpSuppDemandCalendarDTO>> listMap = dtos.stream().collect(Collectors.groupingBy(v -> this.getString(v.getSuppCode(), v.getType(), v.getStoreWhCode(), v.getYear(), v.getMonth())));
            paging.getRecords().forEach(d -> {
                String concatKey = this.getString(d.getSuppCode(), d.getType(), d.getStoreWhCode(), d.getYear(), d.getMonth());
                List calendarDTOS = (List)listMap.get(concatKey);
                if (CollectionUtils.isNotEmpty((Collection)calendarDTOS)) {
                    d.setId(((ScpSuppDemandCalendarDTO)calendarDTOS.get(0)).getId());
                    List details = calendarDTOS.stream().map(m -> {
                        ScpSuppDemandCalendarPageVO.CalendarDayDetail detail = ScpSuppDemandCalendarConvert.INSTANCE.dtoToPageVo((ScpSuppDemandCalendarDTO)m);
                        detail.setDay(m.getDay());
                        detail.setWorkStatus(m.getWorkStatus());
                        return detail;
                    }).collect(Collectors.toList());
                    List<ScpSuppDemandCalendarPageVO.CalendarDayDetail> sortList = details.stream().filter(v -> v.getDay() != null).sorted(this.getComparing()).collect(Collectors.toList());
                    d.setDayDetails(sortList);
                }
            });
        }
        return paging;
    }

    private void extractedAuthorityParam(BaseScpmanAuthorityParam queryParam, PagingVO<ScpManAuthorityPageRespVO> userAuthority) {
        List<String> whCodes = userAuthority.stream().filter(v -> 1 == v.getType()).map(ScpManAuthorityPageRespVO::getStWhCode).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> stores = userAuthority.stream().filter(v -> 0 == v.getType()).map(ScpManAuthorityPageRespVO::getStWhCode).filter(Objects::nonNull).collect(Collectors.toList());
        queryParam.setWhCodes(whCodes);
        queryParam.setStores(stores);
        queryParam.setScpmanAuthority(Boolean.TRUE);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveSuppCalendar(ScpSuppDemandCalendarSaveVO createParam) {
        List<ScpSuppDemandCalendarSaveVO.CalendarDayDetail> dayDetails = createParam.getDetails();
        List calendarDTOList = dayDetails.stream().map(d -> {
            ScpSuppDemandCalendarDTO demandCalendarDTO = ScpSuppDemandCalendarConvert.INSTANCE.saveVoToDto((ScpSuppDemandCalendarSaveVO.CalendarDayDetail)d);
            demandCalendarDTO.setType(createParam.getType());
            demandCalendarDTO.setSuppCode(createParam.getSuppCode());
            demandCalendarDTO.setSuppId(createParam.getSuppId());
            demandCalendarDTO.setSuppName(createParam.getSuppName());
            demandCalendarDTO.setStoreWhCode(createParam.getStoreWhCode());
            demandCalendarDTO.setStoreWhId(createParam.getStoreWhId());
            demandCalendarDTO.setStoreWhName(createParam.getStoreWhName());
            demandCalendarDTO.setYear(createParam.getYear());
            demandCalendarDTO.setMonth(createParam.getMonth());
            return demandCalendarDTO;
        }).collect(Collectors.toList());
        List<ScpSuppDemandCalendarDTO> saveList = calendarDTOList.stream().filter(d -> d.getId() == null).collect(Collectors.toList());
        List<ScpSuppDemandCalendarDTO> updateList = calendarDTOList.stream().filter(d -> d.getId() != null).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(saveList)) {
            List<String> concatKey = saveList.stream().map(d -> d.getSuppCode() + d.getType() + d.getStoreWhCode() + d.getYear() + d.getMonth() + d.getDay()).collect(Collectors.toList());
            List<ScpSuppDemandCalendarDTO> existList = this.scpSuppCalendarDomainService.findCalendarByStoreDayConcatStr(concatKey);
            if (CollectionUtils.isNotEmpty(existList)) {
                List saveKey = saveList.stream().map(d -> d.getSuppCode() + d.getType() + d.getStoreWhCode() + d.getYear() + d.getMonth() + d.getDay()).collect(Collectors.toList());
                List existKeys = existList.stream().filter(d -> saveKey.contains(d.getSuppCode() + d.getType() + d.getStoreWhCode() + d.getYear() + d.getMonth() + d.getDay())).map(d -> d.getSuppCode() + d.getType() + d.getStoreWhCode() + d.getYear() + d.getMonth() + d.getDay()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(existKeys)) {
                    throw new BusinessException(ApiCode.FAIL, String.join((CharSequence)",", existKeys) + "\u914d\u7f6e\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539");
                }
            }
            this.scpSuppCalendarDomainService.createBatch(saveList);
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.scpSuppCalendarDomainService.createBatch(updateList);
        }
    }

    @Override
    public ScpSuppDemandCalendarRespVO findSuppCalendarListByParam(ScpSuppDemandCalendarParamVO param) {
        ScpSuppDemandCalendarRespVO vo = new ScpSuppDemandCalendarRespVO();
        List<ScpSuppDemandCalendarDTO> calendarDOS = this.scpSuppCalendarDomainService.findSuppCalendarListByParam(param);
        if (CollectionUtils.isEmpty(calendarDOS)) {
            return vo;
        }
        if (param.getMonth() != null && param.getYear() != null) {
            List calendarRespVOS = calendarDOS.stream().map(ScpSuppDemandCalendarConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
            ScpSuppDemandCalendarRespVO calendarRespVO = (ScpSuppDemandCalendarRespVO)calendarRespVOS.get(0);
            BeanCopyUtil.beanCopyWithIngore((Object)calendarRespVO, (Object)vo, (String[])BeanCopyUtil.getNullAndIgnorePropertyNames((Object)calendarRespVO, (String[])new String[0]));
            List<ScpSuppDemandCalendarRespVO> vos = calendarRespVOS.stream().filter(d -> d.getDay() != null).sorted(this.getComparing2()).collect(Collectors.toList());
            vo.setDetails(vos);
            List<String> years = calendarDOS.stream().map(ScpSuppDemandCalendarDTO::getYear).distinct().collect(Collectors.toList());
            List<String> months = calendarDOS.stream().map(ScpSuppDemandCalendarDTO::getMonth).distinct().collect(Collectors.toList());
            List<String> days = calendarDOS.stream().map(ScpSuppDemandCalendarDTO::getDay).distinct().collect(Collectors.toList());
            vo.setExistYears(years);
            vo.setExistMonthsOfYear(months);
            vo.setExistDaysOfMonth(days);
        } else if (param.getYear() != null && param.getMonth() == null) {
            List<String> years = calendarDOS.stream().map(ScpSuppDemandCalendarDTO::getYear).distinct().collect(Collectors.toList());
            List<String> months = calendarDOS.stream().map(ScpSuppDemandCalendarDTO::getMonth).distinct().collect(Collectors.toList());
            vo.setExistYears(years);
            vo.setExistMonthsOfYear(months);
        } else if (param.getYear() == null && param.getMonth() == null) {
            List<String> years = calendarDOS.stream().map(ScpSuppDemandCalendarDTO::getYear).distinct().collect(Collectors.toList());
            vo.setExistYears(years);
        }
        return vo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSuppCalendar(List<ScpSuppDemandCalendarParamVO> param) {
        this.verifyParam(param);
        List<String> concatKey = param.stream().map(d -> d.getSuppCode() + d.getType() + d.getStoreWhCode() + d.getYear() + d.getMonth()).collect(Collectors.toList());
        List<ScpSuppDemandCalendarDTO> dtos = this.scpSuppCalendarDomainService.findCalendarListByConcatStr(concatKey);
        if (CollectionUtils.isNotEmpty(dtos)) {
            List<Long> ids = dtos.stream().map(BaseViewModel::getId).distinct().collect(Collectors.toList());
            this.scpSuppCalendarDomainService.deleteBatch(ids);
        }
    }

    private void verifyParam(List<ScpSuppDemandCalendarParamVO> param) {
        long nullcount = param.stream().filter(d -> d.getYear() == null).count();
        if (nullcount > 0L) {
            throw new BusinessException(ApiCode.FAIL, "\u5e74\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long nullcount2 = param.stream().filter(d -> d.getMonth() == null).count();
        if (nullcount2 > 0L) {
            throw new BusinessException(ApiCode.FAIL, "\u6708\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @NotNull
    private String getString(String suppCode, String type, String storeWhCode, String year, String month) {
        return suppCode + type + storeWhCode + year + month;
    }

    @NotNull
    private String getBusinessString(ScpSuppDemandCalendarPageVO d) {
        return this.getString(d.getSuppCode(), d.getType(), d.getStoreWhCode(), d.getYear(), d.getMonth());
    }

    private Comparator<ScpSuppDemandCalendarPageVO.CalendarDayDetail> getComparing() {
        return Comparator.comparing(v -> Integer.parseInt(v.getDay()), Comparator.nullsLast(Comparator.naturalOrder()));
    }

    private Comparator<ScpSuppDemandCalendarRespVO> getComparing2() {
        return Comparator.comparing(v -> Integer.parseInt(v.getDay()), Comparator.nullsLast(Comparator.naturalOrder()));
    }

    public ScpSuppDemandCalendarServiceImpl(ScpSuppDemandCalendarDomainService scpSuppCalendarDomainService, ScpDemandAuthorityService scpDemandAuthorityService) {
        this.scpSuppCalendarDomainService = scpSuppCalendarDomainService;
        this.scpDemandAuthorityService = scpDemandAuthorityService;
    }
}

