/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.feedback;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackApproveVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackQueryParamVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackRespVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackSaveVO;
import com.elitesland.scp.application.service.feedback.ScpStoreFeedbackService;
import com.elitesland.scp.domain.service.feedback.ScpStoreFeedbackDomainService;
import com.elitesland.scp.enums.ProcDefKey;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.utils.WorkFlowUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.github.houbb.sensitive.word.bs.SensitiveWordBs;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;

@Service(value="scpStoreFeedbackService")
public class ScpStoreFeedbackServiceImpl
implements ScpStoreFeedbackService {
    private static final Logger log = LoggerFactory.getLogger(ScpStoreFeedbackServiceImpl.class);
    private final ScpStoreFeedbackDomainService scpStoreFeedbackDomainService;
    private final WorkflowService workflowService;
    private final WorkFlowUtil workFlowUtil;
    private final TransactionTemplate transactionTemplate;
    private final SensitiveWordBs sensitiveWordBs;

    @Override
    @SysCodeProc
    public PagingVO<ScpStoreFeedbackRespVO> search(ScpStoreFeedbackQueryParamVO param) {
        return this.scpStoreFeedbackDomainService.search(param);
    }

    @Override
    @SysCodeProc
    public PagingVO<ScpStoreFeedbackRespVO> searchByPc(ScpStoreFeedbackQueryParamVO param) {
        param.setFilteredFeedbackStatus(ScpUdcEnum.FEEDBACK_STATUS_DRAFT.getValueCode());
        return this.scpStoreFeedbackDomainService.search(param);
    }

    @Override
    @SysCodeProc
    public Optional<ScpStoreFeedbackRespVO> findIdOne(Long id) {
        Optional<ScpStoreFeedbackRespVO> idOne = this.scpStoreFeedbackDomainService.findIdOne(id);
        idOne.ifPresent(item -> {
            if (item.getFileUrl() != null) {
                item.setFileUrlList(JSONObject.parseArray((String)item.getFileUrl(), ScpStoreFeedbackRespVO.FileObject.class));
            }
            String replace = this.sensitiveWordBs.replace(item.getEvaluationComment());
            item.setEvaluationComment(replace);
            String replace1 = this.sensitiveWordBs.replace(item.getOptimizationSuggestion());
            item.setOptimizationSuggestion(replace1);
        });
        return idOne;
    }

    @Override
    @Transactional
    public Long createOrUpdate(ScpStoreFeedbackSaveVO param) {
        return this.scpStoreFeedbackDomainService.createOne(param);
    }

    @Override
    @Transactional
    public void approveBatch(ScpStoreFeedbackApproveVO params) {
        List<ScpStoreFeedbackRespVO> idBatch;
        if (!CollectionUtils.isEmpty(params.getIds()) && !CollectionUtils.isEmpty(idBatch = this.scpStoreFeedbackDomainService.findIdBatch(params.getIds()))) {
            idBatch.stream().filter(vo -> ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_VALID.getValueCode().equals(vo.getApprovalStatus())).findAny().ifPresent(vo -> {
                throw new BusinessException("\u53cd\u9988\u5546\u54c1\u5df2\u5ba1\u6279\u901a\u8fc7\uff0c\u4e0d\u80fd\u91cd\u590d\u5ba1\u6279: " + vo.getItemName());
            });
            idBatch.forEach(vo -> {
                if (params.getIsApprove().booleanValue()) {
                    this.scpStoreFeedbackDomainService.statusChangeByProcess(vo.getId(), ProcInstStatus.APPROVED, "");
                } else {
                    this.scpStoreFeedbackDomainService.statusChangeByProcess(vo.getId(), ProcInstStatus.REJECTED, "");
                }
            });
        }
    }

    @Override
    @Transactional
    public List<Long> createOrUpdateBatch(List<ScpStoreFeedbackSaveVO> params) {
        this.transactionTemplate.setPropagationBehavior(3);
        this.transactionTemplate.execute(transactionStatus -> {
            try {
                List<ScpStoreFeedbackRespVO> idBatch;
                List<Long> ids = params.stream().map(ScpStoreFeedbackSaveVO::getId).filter(Objects::nonNull).toList();
                if (!CollectionUtils.isEmpty(ids) && !CollectionUtils.isEmpty(idBatch = this.scpStoreFeedbackDomainService.findIdBatch(ids))) {
                    idBatch.forEach(vo -> {
                        if (!ScpUdcEnum.FEEDBACK_STATUS_DRAFT.getValueCode().equals(vo.getFeedbackStatus())) {
                            throw new RuntimeException("\u53cd\u9988\u5546\u54c1\u72b6\u6001\u4e0d\u662f\u8349\u7a3f\uff0c\u4e0d\u80fd\u4fee\u6539\u6216\u63d0\u4ea4: " + vo.getItemName());
                        }
                    });
                    this.scpStoreFeedbackDomainService.deleteBatch(ids);
                }
                params.forEach(param -> {
                    param.setFeedbackStatus(ScpUdcEnum.FEEDBACK_STATUS_DRAFT.getValueCode());
                    if (param.getIsSubmit() != null && param.getIsSubmit().booleanValue()) {
                        param.setFeedbackStatus(ScpUdcEnum.FEEDBACK_STATUS_APPROVING.getValueCode());
                        param.setApprovalStatus(ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_APPROVING.getValueCode());
                    }
                    if (!CollectionUtils.isEmpty(param.getFileUrlList())) {
                        param.setFileUrl(JSONObject.toJSONString(param.getFileUrlList()));
                    }
                    Long one = this.scpStoreFeedbackDomainService.createOne((ScpStoreFeedbackSaveVO)param);
                    param.setId(one);
                });
                return null;
            }
            catch (RuntimeException e) {
                log.error("createFeedback error:{}", (Throwable)e);
                transactionStatus.setRollbackOnly();
                throw new BusinessException(ApiCode.FAIL, e.getMessage());
            }
        });
        return params.stream().map(ScpStoreFeedbackSaveVO::getId).collect(Collectors.toList());
    }

    private void submit(ScpStoreFeedbackSaveVO param, Long id) {
        String procInstName = "\u95e8\u5e97\u53cd\u9988\u6d41\u7a0b-" + param.getFeedbackStoreName();
        log.info("\u95e8\u5e97\u53cd\u9988\u542f\u52a8\u6d41\u7a0b\u5165\u53c2: processDefinitionKey:" + ProcDefKey.FEEDBACK_PROCESS.name() + ",procInstName\uff1a" + procInstName + ",businessKey: " + id + ",null,tenantId\uff1a1");
        WorkflowResult processInfoWorkflowResult = this.workflowService.startProcess(StartProcessPayload.of((String)ProcDefKey.FEEDBACK_PROCESS.name(), (String)procInstName, (String)("" + id), null));
        log.info("\u95e8\u5e97\u53cd\u9988\u542f\u52a8\u6d41\u7a0b\u8fd4\u56de:" + processInfoWorkflowResult);
        if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
            throw new BusinessException("\u8c03\u7528\u5de5\u4f5c\u6d41\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f:" + processInfoWorkflowResult.getMsg());
        }
        String procInstId = ((ProcessInfo)processInfoWorkflowResult.getData()).getProcInstId();
        param.setProcInstId(procInstId);
        param.setSubmitTime(LocalDateTime.now());
        param.setProcInstStatus(((ProcessInfo)processInfoWorkflowResult.getData()).getProcInstStatus());
        this.scpStoreFeedbackDomainService.createOne(param);
    }

    public ScpStoreFeedbackServiceImpl(ScpStoreFeedbackDomainService scpStoreFeedbackDomainService, WorkflowService workflowService, WorkFlowUtil workFlowUtil, TransactionTemplate transactionTemplate, SensitiveWordBs sensitiveWordBs) {
        this.scpStoreFeedbackDomainService = scpStoreFeedbackDomainService;
        this.workflowService = workflowService;
        this.workFlowUtil = workFlowUtil;
        this.transactionTemplate = transactionTemplate;
        this.sensitiveWordBs = sensitiveWordBs;
    }
}

