/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.lakalapay.controller;

import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitesland.scp.lakalapay.service.LklPaymentService;
import com.elitesland.scp.lakalapay.vo.BalanceResponseVO;
import com.elitesland.scp.lakalapay.vo.OnlineLklPayOrderParamVO;
import com.elitesland.scp.lakalapay.vo.OnlineLklPayOrderResponseVO;
import com.elitesland.scp.lakalapay.vo.QueryAccountDtlParamVO;
import com.elitesland.scp.lakalapay.vo.QueryBalanceParamVO;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/payments"})
@Validated
public class LakalaPaymentController {
    private static final Logger log = LoggerFactory.getLogger(LakalaPaymentController.class);
    private final LklPaymentService paymentService;

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u652f\u4ed8\u4e0b\u5355")
    @PostMapping(value={"/online/lkl-pay"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.ELSE, operationDescription="\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u652f\u4ed8\u4e0b\u5355", allowRepeatRequest=false)
    public OnlineLklPayOrderResponseVO createOnlineMPPay(HttpServletRequest request, @RequestBody @Validated OnlineLklPayOrderParamVO param) {
        log.info("\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u652f\u4ed8\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONUtil.toJsonStr((Object)param));
        String clientIP = ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
        param.setClientIp(clientIP);
        return this.paymentService.createMpPayOnline(param);
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u4f59\u989d\u67e5\u8be2")
    @PostMapping(value={"/balance"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.ELSE, operationDescription="\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u4f59\u989d\u67e5\u8be2", allowRepeatRequest=false)
    public BalanceResponseVO queryBalance(@RequestBody @Validated QueryBalanceParamVO param) {
        log.info("\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u4f59\u989d\u67e5\u8be2\uff1a{}", (Object)JSONUtil.toJsonStr((Object)param));
        return this.paymentService.queryBalance(param);
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u8d22\u52a1\u660e\u7ec6\u67e5\u8be2")
    @PostMapping(value={"/queryAccountDtl"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.ELSE, operationDescription="\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u8d22\u52a1\u660e\u7ec6\u67e5\u8be2", allowRepeatRequest=false)
    public String queryAccountDtl(@RequestBody @Validated QueryAccountDtlParamVO param) {
        log.info("\u5c0f\u7a0b\u5e8f\u62c9\u5361\u62c9\u8d22\u52a1\u660e\u7ec6\u67e5\u8be2\uff1a{}", (Object)JSONUtil.toJsonStr((Object)param));
        return this.paymentService.queryAccountDtl(param);
    }

    public LakalaPaymentController(LklPaymentService paymentService) {
        this.paymentService = paymentService;
    }
}

