/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.utils.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitesland.scp.utils.excel.AliasRowWriteHandle;
import com.elitesland.scp.utils.excel.StStockAliasRowWriteHandle;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ExcelWriteUtil {
    public OutputStream getOutputStream(HttpServletResponse response, String filename) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        response.reset();
        filename = URLEncoder.encode(filename, StandardCharsets.UTF_8);
        response.setHeader("Content-disposition", "attachment; filename=" + filename + ".xlsx");
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/x-download");
        return outputStream;
    }

    public static void autoAliasExcelWrite(HttpServletResponse response, List<?> list, Class<?> clazz, String fileName, String sheetName) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8);
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        AliasRowWriteHandle aliasRowWriteHandler = new AliasRowWriteHandle();
        ExcelWriterBuilder write = EasyExcel.write((OutputStream)response.getOutputStream(), clazz);
        ((ExcelWriterBuilder)((ExcelWriterBuilder)write.registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).registerWriteHandler((WriteHandler)aliasRowWriteHandler)).sheet(sheetName).doWrite(list);
    }

    public static void autoPredictStStockAliasExcelWrite(HttpServletResponse response, List<?> list, Class<?> clazz, String fileName, String sheetName) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8);
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        StStockAliasRowWriteHandle aliasRowWriteHandler = new StStockAliasRowWriteHandle();
        ExcelWriterBuilder write = EasyExcel.write((OutputStream)response.getOutputStream(), clazz);
        ((ExcelWriterBuilder)((ExcelWriterBuilder)write.registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).registerWriteHandler((WriteHandler)aliasRowWriteHandler)).sheet(sheetName).doWrite(list);
    }
}

