package com.elitesland.scp.domain.entity.collect;

import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel("收藏夹")
public class ScpUserCollectDO implements Serializable {
    private static final long serialVersionUID = -468479604525728438L;

    @ApiModelProperty("登录用户ID")
    private Long userId;

    @ApiModelProperty("门店编码")
    private String demandWhStCode;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty(value = "商品别名")
    private String anotherName;

    @ApiModelProperty(value = "包装规格")
    private String itemAttrName;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("单位名称")
    private String uomName;

    @ApiModelProperty("spu编码")
    private Long spuId;

    @ApiModelProperty("spu编码")
    private String spuCode;

    @ApiModelProperty("spu名称")
    private String spuName;

    @ApiModelProperty("spu规格型号")
    private String spec;

    @ApiModelProperty(value = "SPU商品图片")
    private List<ItmItemAttachmentRpcDTO> spuAttchmentList;

    @ApiModelProperty(value = "SKU商品图片")
    private List<ItmItemAttachmentRpcDTO> skuAttchmentList;

    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品品类名称")
    private String itemCateName;

    @ApiModelProperty(value = "创建时间")
    private String createTime;

    @ApiModelProperty("基本单位")
    private String uom2;
    @ApiModelProperty(value = "基本单位名称")
    private String uom2Name;

    @ApiModelProperty("单位转换系数")
    private BigDecimal uomRatio;

    @ApiModelProperty("有效位数")
    private Integer decimalPlaces;

    @ApiModelProperty(value = "商品分类")
    private String itemType;

    @ApiModelProperty(value = "配送类型")
    private String itemType2;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    private String combineItemName;
}
