package com.elitesland.scp.infr.dto.order;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel("订货订单明细详情返回")
public class ScpDemandOrderDDTO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = 1876265003012913217L;

    @ApiModelProperty("订货订单ID")
    private Long masId;

    @ApiModelProperty("原始id")
    private Long sourceId;

    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    @ApiModelProperty("SPU商品编码")
    private String spuItemCode;

    @ApiModelProperty("SPU商品名称")
    private String spuItemName;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品分类")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty("需求数量")
    private BigDecimal demandQuantity;

    @ApiModelProperty("拆分需求数量")
    private BigDecimal allocationDeQuantity;

    @ApiModelProperty("订货单位")
    private String unit;

    @ApiModelProperty("订货单位名称")
    private String unitName;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("币种，默认CNY")
    private String currency;

    @ApiModelProperty("分配数量")
    private BigDecimal allocationQuantity;

    @ApiModelProperty("类型")
    private String supplyType;

    @ApiModelProperty("供应仓库id、供应商id")
    private Long suppWhId;

    @ApiModelProperty("供应仓库编码、供应商编码")
    private String suppWhCode;

    @ApiModelProperty("供应仓库名称、供应商名称")
    private String suppWhName;

    @ApiModelProperty("采购公司id")
    private Long ouId;

    @ApiModelProperty("采购公司编码")
    private String ouCode;

    @ApiModelProperty("采购公司名称")
    private String ouName;

    @ApiModelProperty("分配单据id")
    private Long srcDocId;

    @ApiModelProperty("分配单据编码")
    private String srcDocNo;

    @ApiModelProperty("分配单据类别")
    private String srcDocCls;

    @ApiModelProperty("分配单据明细行号")
    private String srcDocLineNo;

    @ApiModelProperty("发货数量")
    private BigDecimal quantity;

    @ApiModelProperty("是否已计算")
    private Boolean isCalculated;

    @ApiModelProperty("是否已推送")
    private Boolean isPushed;

    @ApiModelProperty("含税金额")
    private BigDecimal planAmt;

    @ApiModelProperty("计划数量")
    private BigDecimal planQuantity;

    @ApiModelProperty("仓库/供应商分配比例")
    private BigDecimal ratio;

    @ApiModelProperty("推送订单信息")
    private String syncMsg;

    @ApiModelProperty("基本数量")
    private BigDecimal qty2;

    @ApiModelProperty("基本单位")
    private String uom2;
    private String uom2Name;

    @ApiModelProperty("单位转换系数")
    private BigDecimal uomRatio;

    @ApiModelProperty(name = "有效小数位数")
    private Integer decimalPlaces;

    @ApiModelProperty("运费是否计费")
    private Boolean freightFlag;

    @ApiModelProperty("运费比例")
    private BigDecimal freightRatio;

    @ApiModelProperty("销售公司编码")
    private String saleOuCode;

    @ApiModelProperty("销售公司名称")
    private String saleOuName;

    @ApiModelProperty("是否运费行，true:是，false:否")
    private Boolean freightLineFlag;

    @ApiModelProperty("收货数量")
    private BigDecimal recvQty;

    @ApiModelProperty("付款状态")
    private String payStatus;

    @ApiModelProperty("销售客户编码")
    private String saleCustCode;

    @ApiModelProperty(value = "商品图片")
    private String imgUrl;

    @ApiModelProperty("最小强配数量")
    private BigDecimal minNum;

    @ApiModelProperty("强配活动编码")
    private String activityCode;

    @ApiModelProperty("强配活动ID")
    private Long activityId;

    @ApiModelProperty("在线支付标识")
    private Boolean onlinePayFlag;

    @ApiModelProperty("付款人")
    private String payerName;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    private String combineItemName;
}
