package com.elitesland.scp.lakalapay.controller;


import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitesland.scp.lakalapay.service.LklPaymentService;
import com.elitesland.scp.lakalapay.vo.*;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;


@Slf4j
@RestController
@RequestMapping("/payments")
@RequiredArgsConstructor
@Validated
public class LakalaPaymentController {

    private final LklPaymentService paymentService;

    @ApiOperation(value = "小程序拉卡拉支付下单")
    @PostMapping("/online/lkl-pay")
    @BusinessObjectOperation(operationType = OperationTypeEnum.ELSE, operationDescription = "小程序拉卡拉支付下单", allowRepeatRequest = false)
    public OnlineLklPayOrderResponseVO createOnlineMPPay(HttpServletRequest request, @RequestBody @Validated OnlineLklPayOrderParamVO param) {
        log.info("小程序拉卡拉支付下单请求参数：{}", JSONUtil.toJsonStr(param));
        String clientIP = ServletUtil.getClientIP(request);
        param.setClientIp(clientIP);
        return paymentService.createMpPayOnline(param);
    }

    @ApiOperation(value = "小程序拉卡拉余额查询")
    @PostMapping("/balance")
    @BusinessObjectOperation(operationType = OperationTypeEnum.ELSE, operationDescription = "小程序拉卡拉余额查询", allowRepeatRequest = false)
    public BalanceResponseVO queryBalance(@RequestBody @Validated QueryBalanceParamVO param) {
        log.info("小程序拉卡拉余额查询：{}", JSONUtil.toJsonStr(param));
        return paymentService.queryBalance(param);
    }

    @ApiOperation(value = "小程序拉卡拉财务明细查询")
    @PostMapping("/queryAccountDtl")
    @BusinessObjectOperation(operationType = OperationTypeEnum.ELSE, operationDescription = "小程序拉卡拉财务明细查询", allowRepeatRequest = false)
    public String queryAccountDtl(@RequestBody @Validated QueryAccountDtlParamVO param) {
        log.info("小程序拉卡拉财务明细查询：{}", JSONUtil.toJsonStr(param));
        return paymentService.queryAccountDtl(param);
    }


}
