package com.elitesland.scp.lakalapay.service;


import com.elitesland.scp.lakalapay.vo.*;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import org.springframework.boot.configurationprocessor.json.JSONException;

public interface LklPaymentService {

    /**
     * 小程序支付下单-在线
     *
     * @return
     */
    OnlineLklPayOrderResponseVO createMpPayOnline(OnlineLklPayOrderParamVO param);

    /**
     * 查询余额
     *
     * @param param
     * @return
     */
    BalanceResponseVO queryBalance(QueryBalanceParamVO param);

    String queryAccountDtl(QueryAccountDtlParamVO param);

    /**
     * 支付回调
     *
     * @param body
     * @return
     */
    String paymentNotify(String body) throws EntpayException, JSONException;

}
