package com.elitesland.scp.lakalapay.service;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitesland.inv.dto.invTro.InvTroOnlinePayParamDTO;
import com.elitesland.pur.dto.po.PurPoOnlinePayParamDTO;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderPayMqParam;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderUpdatePayStatusMqParam;
import com.elitesland.scp.common.ScpConstant;
//import com.elitesland.scp.domain.entity.lakalapay.LakalaPayRecordDO;
//import com.elitesland.scp.enums.ScpUdcEnum;
//import com.elitesland.scp.infr.repo.lakalapay.LakalaPayRecordRepo;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountRepoProc;
import com.elitesland.scp.lakalapay.utils.RSA;
import com.elitesland.scp.lakalapay.utils.TcslPay;
import com.elitesland.scp.lakalapay.vo.*;
import com.elitesland.scp.pay.service.AccountLinkService;
import com.elitesland.scp.pay.service.NotifyVerifyService;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiPurRpcService;
import com.elitesland.scp.utils.MessageDelyQueueService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.org.dto.OrgBankRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuBankRpcDTO;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@Slf4j
@Service
@RequiredArgsConstructor
public class LklPaymentServiceImpl implements LklPaymentService {

    private final NotifyVerifyService notifyVerifyService;
    private final RedisWrapper redisWrapper;
    private final RedisUtils redisUtils;
    private final RmiPurRpcService rmiPurRpcService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final AccountLinkService accountLinkService;
    private final MessageQueueTemplate messageQueueTemplate;
    private final ScpWqfEntAccountRepoProc scpWqfEntAccountRepoProc;

    private final MessageDelyQueueService messageDelyQueueService;
    private final OrgStoreRpcService orgStoreRpcService;
    private final OrgOuRpcService orgOuRpcService;

    private final TenantDataIsolateProvider tenantDataIsolateProvider;
    private final TransactionTemplate transactionTemplate;
    private final RedisTemplate<Object, Object> redisTemplate;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;
    private final TcslPay tcslPay;


//    private final LakalaPayRecordRepo lakalaPayRecordRepo;


    @Override
    // 在方法上添加重试注解
    @Retryable(value = {Exception.class}, maxAttempts = 3, backoff = @Backoff(delay = 1000))
    public OnlineLklPayOrderResponseVO createMpPayOnline(OnlineLklPayOrderParamVO param) {
        try {
            String docCls = param.getDocNo().substring(0, 2);
            String docNo = param.getDocNo();

            //查询订单支付结果
            OnlineLklPayOrderResultResponseVO onlineLklPayOrderResultResponseVO = tcslPay.queryResult(docNo);
            if (onlineLklPayOrderResultResponseVO != null && onlineLklPayOrderResultResponseVO.getResultCode().equals("0")) {
                throw new BusinessException("订单已支付");
            }

            //构建支付明细
            OnlineLklPayOrderResponseVO onlineLklPayOrderResponseVO = buildPayItems(param, docCls);
            if (onlineLklPayOrderResponseVO != null) {
                return onlineLklPayOrderResponseVO;
            }
            buildPaymentMapParam(param);
            OnlineLklPayOrderResponseVO pay = tcslPay.pay(param);

            if(pay == null || pay.getPayUrl() == null){
                throw new BusinessException("获取支付链接失败");
            }

            //写入mq队列
            ScpOrderUpdatePayStatusMqParam updateParamVO = new ScpOrderUpdatePayStatusMqParam();
            updateParamVO.setBusinessKey(ScpOrderUpdatePayStatusMqParam.SCP_ORDER_UPDATE_PAY_STATUS_CHANNEL);
            updateParamVO.setDocNo(param.getDocNo());
            updateParamVO.setPaymentId(pay.getTradeNo());
            updateParamVO.setAmt(param.getAmt());
            updateParamVO.setPayerName(param.getPayerName());
            updateParamVO.setDocCls(docCls);
            messageQueueTemplate.publishMessageSync("yst-suplan", ScpOrderUpdatePayStatusMqParam.SCP_ORDER_UPDATE_PAY_STATUS_CHANNEL, updateParamVO);
            redisUtils.set(ScpConstant.SCP_ONLINE_PAY + docNo, JSONUtil.toJsonStr(pay.getPayUrl()), 25, TimeUnit.HOURS);
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime expireTime = now.plusDays(1);
            Duration duration = Duration.between(now, expireTime);
            messageDelyQueueService.resettingOrderExpireTime(ScpConstant.SCP_ONLINE_PAY + docNo, duration.toMillis());
            return pay;
        } catch (Exception e) {
            throw new BusinessException("拉卡拉支付失败" + e.getMessage());
        }
    }

    @Override
    public BalanceResponseVO queryBalance(QueryBalanceParamVO param) {
        try {
            List<OrgBankRpcDTO> bankByStoreCode = orgStoreRpcService.findBankByStoreCode(param.getStoreCode());
            if (bankByStoreCode == null || bankByStoreCode.isEmpty()) {
                throw new BusinessException("门店["+param.getStoreCode()+"]未绑定银行信息");
            }
            Optional<OrgBankRpcDTO> orgBankRpcDTO = bankByStoreCode.stream().filter(bank -> bank.getOpenBank().equals("拉卡拉")).findAny();
            if(orgBankRpcDTO.isEmpty()){
                throw new BusinessException("门店["+param.getStoreCode()+"]未绑定拉卡拉银行信息");
            }
            OrgBankRpcDTO orgBankRpcDTO1 = orgBankRpcDTO.get();
            param.setAccountNo(orgBankRpcDTO1.getCardNo());
            param.setBrandId(10L);
            return tcslPay.queryBalance(param);
        } catch (Exception e) {
            throw new BusinessException("拉卡拉余额查询失败" + e.getMessage());
        }
    }

    @Override
    public String queryAccountDtl(QueryAccountDtlParamVO param) {
        try {
            List<OrgBankRpcDTO> bankByStoreCode = orgStoreRpcService.findBankByStoreCode(param.getStoreCode());
            if (bankByStoreCode == null || bankByStoreCode.isEmpty()) {
                throw new BusinessException("门店["+param.getStoreCode()+"]未绑定银行信息");
            }
            Optional<OrgBankRpcDTO> orgBankRpcDTO = bankByStoreCode.stream().filter(bank -> bank.getOpenBank().equals("拉卡拉")).findAny();
            if(orgBankRpcDTO.isEmpty()){
                throw new BusinessException("门店["+param.getStoreCode()+"]未绑定拉卡拉银行信息");
            }
            OrgBankRpcDTO orgBankRpcDTO1 = orgBankRpcDTO.get();
            param.setAccountNo(orgBankRpcDTO1.getCardNo());
            param.setBrandId(10L);
            return tcslPay.queryAccountDtl(param);
        } catch (Exception e) {
            throw new BusinessException("拉卡拉财务明细查询失败" + e.getMessage());
        }
    }

    private OnlineLklPayOrderResponseVO buildPayItems(OnlineLklPayOrderParamVO param, String docCls) {
        OnlineLklPayOrderResponseVO onlineLklPayOrderResponseVO = new OnlineLklPayOrderResponseVO();
        Object obj = redisUtils.get(ScpConstant.SCP_ONLINE_PAY + param.getDocNo());
        OnlineLklPayOrderParamVO.PayeeInfoVO payeeInfoVO = new OnlineLklPayOrderParamVO.PayeeInfoVO();
        payeeInfoVO.setSubTradeAmount(param.getAmt().setScale(2, RoundingMode.HALF_UP)+"");
        List<OrgOuBankRpcDTO> ouBank = orgOuRpcService.findOuBank(param.getOuId());
        if (ouBank == null || ouBank.isEmpty()) {
            throw new BusinessException("销售方未绑定银行卡");
        }
        Optional<OrgOuBankRpcDTO> in = ouBank.stream().filter(a -> a.getAccType().equals("IN")).findAny();
        if (in.isEmpty()) {
            throw new BusinessException("销售方未绑定银行卡");
        }
        OrgOuBankRpcDTO orgOuBankRpcDTO = in.get();
        payeeInfoVO.setPayeeAccountNo(orgOuBankRpcDTO.getBankAcc());
        payeeInfoVO.setPayeeName(orgOuBankRpcDTO.getHolderName());
        payeeInfoVO.setSubOutTradeNo(param.getDocNo());
        param.setPayeeInfo(List.of(payeeInfoVO));
        if ("PO".equals(docCls)) {
            var onlinePayInfo = rmiPurRpcService.findOnlinePayInfo(param.getDocId());
            if (onlinePayInfo == null) {
                throw new BusinessException("支付订单不存在，请联系管理员");
            }
            if (onlinePayInfo.getOnlinePayFlag()) {
                throw new BusinessException("订单已支付");
            }
            if (obj != null && !onlinePayInfo.getOnlinePayFlag()) {
                String url = JSON.parseObject((String) obj, String.class);
                onlineLklPayOrderResponseVO.setPayUrl(url);
                return onlineLklPayOrderResponseVO;
            }
        } else {
            var onlinePayInfo = rmiInvStkRpcService.findOnlinePayInfo(param.getDocId());
            if (onlinePayInfo == null) {
                throw new BusinessException("支付订单不存在，请联系管理员");
            }
            if (onlinePayInfo.getOnlinePayFlag()) {
                throw new BusinessException("订单已支付");
            }
            if (obj != null && !onlinePayInfo.getOnlinePayFlag()) {
                String url = JSON.parseObject((String) obj, String.class);
                onlineLklPayOrderResponseVO.setPayUrl(url);
                return onlineLklPayOrderResponseVO;
            }
        }
        return null;
    }


    private void buildPaymentMapParam(OnlineLklPayOrderParamVO param) {
        List<OrgBankRpcDTO> bankByStoreCode = orgStoreRpcService.findBankByStoreCode(param.getStoreCode());
        if (bankByStoreCode == null || bankByStoreCode.isEmpty()) {
            throw new BusinessException("门店["+param.getStoreCode()+"]未绑定银行信息");
        }
        Optional<OrgBankRpcDTO> orgBankRpcDTO = bankByStoreCode.stream().filter(bank -> bank.getOpenBank().equals("拉卡拉")).findAny();
        if(orgBankRpcDTO.isEmpty()){
            throw new BusinessException("门店["+param.getStoreCode()+"]未绑定拉卡拉银行信息");
        }
        OrgBankRpcDTO orgBankRpcDTO1 = orgBankRpcDTO.get();
        param.setPayerName(orgBankRpcDTO1.getName());
        param.setPayerNo(orgBankRpcDTO1.getCardNo());
        param.setPayerType(orgBankRpcDTO1.getType());

    }

    @Override
    public String paymentNotify(String bytes) throws JSONException {
        log.info("支付回调通知数据：{}", JSONUtil.toJsonStr(bytes));

        byte[] bytes1 = Base64.decodeBase64(bytes);
        Map<String, Object> map = (Map) JSON.parseObject(bytes1, Map.class);
        log.info("支付回调通知数据解析：{}", JSONUtil.toJsonStr(map));
        String sign = (String) map.get("sign");

        RSA.getSignHmacSHA256(map, sign);
        String data = (String) map.get("data");
        Map<String, Object> result = (Map) JSON.parseObject(data, Map.class);
        String docNo = (String) result.get("outTradeNo");
        String tradeNo = (String) result.get("tradeNo");
        String tradeAmount = (String) result.get("tradeAmount");
        String paySuccessTime = (String) result.get("paySuccessTime");
        //设置租户信息
        tenantDataIsolateProvider.byTenantDirectly(() -> {
            TenantContextHolder.setCurrentTenant(TenantClient.getSessionTenant());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            if ("PO".equals(docNo.substring(0, 2))) {
                PurPoOnlinePayParamDTO purPoOnlinePayParamDTO = new PurPoOnlinePayParamDTO();
                purPoOnlinePayParamDTO.setOnlinePayFlag(Boolean.TRUE);
                purPoOnlinePayParamDTO.setDocNo(docNo);
                purPoOnlinePayParamDTO.setOnlinePayTime(LocalDateTime.parse(paySuccessTime, formatter));
                rmiPurRpcService.updateOnlinePay(purPoOnlinePayParamDTO);
            } else {
                InvTroOnlinePayParamDTO invTroOnlinePayParamDTO = new InvTroOnlinePayParamDTO();
                invTroOnlinePayParamDTO.setDocNo(docNo);
//                invTroOnlinePayParamDTO.setOnlinePayTime(LocalDateTime.parse(eventContent.getPayTime(), formatter));
                invTroOnlinePayParamDTO.setOnlinePayFlag(Boolean.TRUE);
                rmiInvStkRpcService.updateOnlinePay(invTroOnlinePayParamDTO);
            }
            String key = ScpConstant.SCP_ONLINE_PAY + docNo;
            //删除缓存
            if (redisTemplate.delete(key)) {
                //删除延时队列
                messageDelyQueueService.remove(key);
                //更新订货单状态为支付中
                transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
                transactionTemplate.execute(transactionStatus -> {
                    try {
                        scpDemandOrderDRepoProc.updatePayStatusBySrcDocId(docNo, ScpUdcEnum.PAY_STATUS_PAYING.getValueCode());
                        return "ok";
                    } catch (Exception e) {
                        log.error("更新要货单出错:{}", e.getMessage(), e);
                        // 回滚
                        transactionStatus.setRollbackOnly();
                        return "ok";
                    }
                });
                //写入mq队列,进行收货确认
                ScpOrderPayMqParam orderSubmitMqParam = new ScpOrderPayMqParam();
                orderSubmitMqParam.setSrcDocNo(docNo);
                orderSubmitMqParam.setFlowNo(tradeNo);
                orderSubmitMqParam.setBusinessKey(ScpOrderPayMqParam.SCP_ORDER_PAY_CHANNEL);
                orderSubmitMqParam.setPayDateTime(LocalDateTime.parse(paySuccessTime, formatter));
                BigDecimal amt = new BigDecimal(tradeAmount).setScale(2, RoundingMode.HALF_UP);
                orderSubmitMqParam.setRealRecAmt(amt);
                messageQueueTemplate.publishMessageSync("yst-suplan", ScpOrderPayMqParam.SCP_ORDER_PAY_CHANNEL, orderSubmitMqParam);
            } else {
                log.error("不能重复调用支付回调");
            }
            return "";
        }, "6008");
        // 封装响应参数
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", 0);
        jsonObject.put("result", "SUCCESS");

//        RSA.sign("result", EntpayConfig.getRealTbepPrivateKey(null))
//        Base64.encodeBase64String(JSON.toJSONBytes(result))
        return jsonObject.toString();
    }
}
