/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.scp.rmi.RmiSysSettingService;
import com.elitesland.support.provider.org.dto.OrgStoreWhDTO;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.springframework.util.CollectionUtils;

public class SysUtils {
    private static final String PRICE_DECIMAL_PLACE = "PRICE_DECIMAL_PLACE";
    private static final String AMOUNT_DECIMAL_PLACE = "AMOUNT_DECIMAL_PLACE";
    private static final String QUANTITY_DECIMAL_PLACE = "QUANTITY_DECIMAL_PLACE";
    private static final String SCP_ORDER_SETTING = "SCP_ORDER_SETTING";
    private static final String SCP_ORDER_ITEM_SETTING = "SCP_ORDER_ITEM_SETTING";
    private static final String RETURN_ORDER_COMPENSATION_ITEM_SETTING = "RETURN_ORDER_COMPENSATION_ITEM_SETTING";
    private static final String SCP_ORDER_ITEM_IMG_URL_SETTING = "SCP_ORDER_ITEM_IMG_URL_SETTING";
    private static final String SCP_ORDER_EXPIRE_SETTING = "SCP_ORDER_EXPIRE_SETTING";
    private static final String INV_OIDOC = "INV_OIDOC";
    private static final String SCP_ORDER_SET_AUTO_CREATE_NUM = "SCP_ORDER_SET_AUTO_CREATE_NUM";
    private static Cache<String, String> orderSettingCache = Caffeine.newBuilder().maximumSize(5L).expireAfterWrite(8L, TimeUnit.HOURS).build();
    private static OrgStoreRpcService orgStoreRpcService;
    private static final Cache<String, List<OrgStoreWhDTO>> storeWhCache;
    private static Cache<String, Integer> placeCache;

    public static Integer getPricePlace() {
        return (Integer)placeCache.get((Object)PRICE_DECIMAL_PLACE, key -> {
            SysSettingVO priceDecimalPlace = ((RmiSysSettingService)SpringUtil.getBean(RmiSysSettingService.class)).findSysSettingByNo(PRICE_DECIMAL_PLACE);
            return priceDecimalPlace == null || StrUtil.isBlank((CharSequence)priceDecimalPlace.getSettingVal()) ? 8 : Integer.parseInt(priceDecimalPlace.getSettingVal().trim());
        });
    }

    public static Integer getAmtPlace() {
        return (Integer)placeCache.get((Object)AMOUNT_DECIMAL_PLACE, key -> {
            SysSettingVO amountDecimalPlace = ((RmiSysSettingService)SpringUtil.getBean(RmiSysSettingService.class)).findSysSettingByNo(AMOUNT_DECIMAL_PLACE);
            return amountDecimalPlace == null || StrUtil.isBlank((CharSequence)amountDecimalPlace.getSettingVal()) ? 8 : Integer.parseInt(amountDecimalPlace.getSettingVal().trim());
        });
    }

    public static Integer getQtyPlace() {
        return (Integer)placeCache.get((Object)QUANTITY_DECIMAL_PLACE, key -> {
            SysSettingVO qtyDecimalPlace = ((RmiSysSettingService)SpringUtil.getBean(RmiSysSettingService.class)).findSysSettingByNo(QUANTITY_DECIMAL_PLACE);
            return qtyDecimalPlace == null || StrUtil.isBlank((CharSequence)qtyDecimalPlace.getSettingVal()) ? 8 : Integer.parseInt(qtyDecimalPlace.getSettingVal().trim());
        });
    }

    public static BigDecimal processPriceScale(BigDecimal number) {
        if (number == null) {
            return null;
        }
        return number.setScale((int)SysUtils.getPricePlace(), RoundingMode.HALF_UP);
    }

    public static BigDecimal processAmtScale(BigDecimal number) {
        if (number == null) {
            return null;
        }
        return number.setScale((int)SysUtils.getAmtPlace(), RoundingMode.HALF_UP);
    }

    public static BigDecimal processQtyScale(BigDecimal number) {
        if (number == null) {
            return null;
        }
        return number.setScale((int)SysUtils.getQtyPlace(), RoundingMode.HALF_UP);
    }

    public static BigDecimal processStoreQtyScale(BigDecimal number) {
        if (number == null) {
            return null;
        }
        return number.setScale(0, RoundingMode.HALF_UP);
    }

    public static Map<String, Integer> refreshSetting() {
        placeCache.invalidateAll();
        SysUtils.getPricePlace();
        SysUtils.getAmtPlace();
        SysUtils.getQtyPlace();
        SysUtils.getOrderSetting();
        SysUtils.getOrderItemSetting();
        return placeCache.asMap();
    }

    public static String getOrderSetting() {
        return (String)orderSettingCache.get((Object)SCP_ORDER_SETTING, key -> {
            SysSettingVO orderSetting = ((RmiSysSettingService)SpringUtil.getBean(RmiSysSettingService.class)).findSysSettingByNo(SCP_ORDER_SETTING);
            return orderSetting == null || StrUtil.isBlank((CharSequence)orderSetting.getSettingVal()) ? "1" : orderSetting.getSettingVal().trim();
        });
    }

    public static String getOrderItemSetting() {
        return (String)orderSettingCache.get((Object)SCP_ORDER_ITEM_SETTING, key -> {
            SysSettingVO orderSetting = ((RmiSysSettingService)SpringUtil.getBean(RmiSysSettingService.class)).findSysSettingByNo(SCP_ORDER_ITEM_SETTING);
            return orderSetting == null || StrUtil.isBlank((CharSequence)orderSetting.getSettingVal()) ? "1" : orderSetting.getSettingVal().trim();
        });
    }

    public static String getOrderItemImgUrlSetting() {
        return (String)orderSettingCache.get((Object)SCP_ORDER_ITEM_IMG_URL_SETTING, key -> {
            SysSettingVO orderSetting = ((RmiSysSettingService)SpringUtil.getBean(RmiSysSettingService.class)).findSysSettingByNo(SCP_ORDER_ITEM_IMG_URL_SETTING);
            return orderSetting == null || StrUtil.isBlank((CharSequence)orderSetting.getSettingVal()) ? "" : orderSetting.getSettingVal().trim();
        });
    }

    public static String getCompItemSetting() {
        return (String)orderSettingCache.get((Object)RETURN_ORDER_COMPENSATION_ITEM_SETTING, key -> {
            SysSettingVO orderSetting = ((RmiSysSettingService)SpringUtil.getBean(RmiSysSettingService.class)).findSysSettingByNo(RETURN_ORDER_COMPENSATION_ITEM_SETTING);
            return orderSetting == null || StrUtil.isBlank((CharSequence)orderSetting.getSettingVal()) ? "1" : orderSetting.getSettingVal().trim();
        });
    }

    public static String generateRedisKey(String prefix, String itemKey) {
        return prefix + ":" + itemKey;
    }

    public static String generateRedisKey(String prefix, String combineItemCode, String itemCode) {
        if (StringUtil.isBlank((CharSequence)combineItemCode)) {
            return prefix + ":" + itemCode;
        }
        return prefix + ":" + combineItemCode + ":" + itemCode;
    }

    public static String generateRedisKey(String prefix, String combineItemCode, String itemCode, String activityCode) {
        if (StringUtil.isBlank((CharSequence)activityCode)) {
            return SysUtils.generateRedisKey(prefix, combineItemCode, itemCode);
        }
        if (StringUtil.isBlank((CharSequence)combineItemCode)) {
            return prefix + ":" + itemCode + ":" + activityCode + ":ALLOC";
        }
        return prefix + ":" + combineItemCode + ":" + itemCode + ":" + activityCode + ":ALLOC";
    }

    public static String getItemKey(String combineItemCode, String itemCode) {
        if (StringUtil.isBlank((CharSequence)combineItemCode)) {
            return itemCode;
        }
        return combineItemCode + ":" + itemCode;
    }

    public static String getItemKey(String combineItemCode, String itemCode, String activityCode) {
        if (StringUtil.isBlank((CharSequence)activityCode)) {
            return SysUtils.getItemKey(combineItemCode, itemCode);
        }
        if (StringUtil.isBlank((CharSequence)combineItemCode)) {
            return itemCode + ":" + activityCode + ":ALLOC";
        }
        return combineItemCode + ":" + itemCode + ":" + activityCode + ":ALLOC";
    }

    public static Map<String, List<OrgStoreWhDTO>> getStoreWhListCache(List<String> storeCodes) {
        if (orgStoreRpcService == null) {
            orgStoreRpcService = (OrgStoreRpcService)SpringContextHolder.getBean(OrgStoreRpcService.class);
        }
        ArrayList<String> notCacheCodes = new ArrayList<String>();
        HashMap<String, List<OrgStoreWhDTO>> storeWhMap = new HashMap<String, List<OrgStoreWhDTO>>();
        for (String store : storeCodes) {
            List storeWhDTOS = (List)storeWhCache.getIfPresent((Object)store);
            if (CollectionUtils.isEmpty((Collection)storeWhDTOS)) {
                notCacheCodes.add(store);
                continue;
            }
            storeWhMap.put(store, storeWhDTOS);
        }
        if (!CollectionUtils.isEmpty(notCacheCodes)) {
            List storeWhDTOS = (List)orgStoreRpcService.listWhByCode(storeCodes).computeData();
            Map<String, List<OrgStoreWhDTO>> map = storeWhDTOS.stream().collect(Collectors.groupingBy(OrgStoreWhDTO::getStoreCode));
            storeWhMap.putAll(map);
            storeWhCache.putAll(map);
        }
        return storeWhMap;
    }

    public static String getInvOidoc() {
        return (String)orderSettingCache.get((Object)INV_OIDOC, key -> {
            SysSettingVO orderSetting = ((RmiSysSettingService)SpringUtil.getBean(RmiSysSettingService.class)).findSysSettingByNo(INV_OIDOC);
            return orderSetting == null || StrUtil.isBlank((CharSequence)orderSetting.getSettingVal()) ? "1" : orderSetting.getSettingVal().trim();
        });
    }

    public static Integer getAutoOrderSetNumSetting() {
        String s = (String)orderSettingCache.get((Object)SCP_ORDER_SET_AUTO_CREATE_NUM, key -> {
            SysSettingVO orderSetting = ((RmiSysSettingService)SpringUtil.getBean(RmiSysSettingService.class)).findSysSettingByNo(SCP_ORDER_SET_AUTO_CREATE_NUM);
            return orderSetting == null || StrUtil.isBlank((CharSequence)orderSetting.getSettingVal()) ? "1" : orderSetting.getSettingVal().trim();
        });
        return Integer.parseInt(s);
    }

    static {
        storeWhCache = Caffeine.newBuilder().maximumSize(200L).expireAfterAccess(8L, TimeUnit.HOURS).build();
        placeCache = Caffeine.newBuilder().maximumSize(3L).expireAfterAccess(8L, TimeUnit.HOURS).build();
    }
}

