package com.elitesland.scp.application.facade.vo.param.order;


import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import javax.persistence.Column;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@Builder
@ApiModel(value = "订货集查询参数")
public class ScpDemandSetParamVO implements Serializable {

    private static final long serialVersionUID = -3413197168012944004L;

    @ApiModelProperty(value = "类型，0:门店，1:仓库", required = true)
    @NotBlank(message = "订单集类型不能为空")
    private String type;

    @ApiModelProperty("订货集编码")
    private String demandCode;

    @ApiModelProperty("订货集名称")
    private String demandName;

    @ApiModelProperty("状态")
    private Boolean status;

    @ApiModelProperty("需求日期")
    private LocalDateTime demandDate;


    private LocalDateTime demandDateFrom;

    private LocalDateTime demandDateTo;


    @ApiModelProperty("是否已推送")
    private Boolean isPushed;

    private LocalDateTime expireTime;

    private List<String> demandNames;
}
