package com.elitesland.scp.application.facade.vo.save.order;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel(value = "移动端订货订单明细提交参数")
public class ScpDemandOrderDSubmitVO implements Serializable {
    private static final long serialVersionUID = 7375318191765426919L;

    @ApiModelProperty("商品SPU编码")
    private String spuCode;

    @ApiModelProperty("商品SPU名称")
    private String spuName;

    private List<ScpDemandOrderDSubmitVO.ItemSpecObjectVO> itemSpecObjectVOS;

    @Data
    public static class ItemSpecObjectVO {

        @ApiModelProperty("商品id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long itemId;

        @ApiModelProperty("商品规格编码(SKU编码)")
        private String itemCode;

        @ApiModelProperty("商品规格名称(SKU名称)")
        private String itemName;

        @ApiModelProperty("需求数量")
        private BigDecimal demandQuantity;

        @ApiModelProperty("单位")
        private String uom;

        @ApiModelProperty("单位名称")
        private String uomName;

        @ApiModelProperty("基本单位")
        private String uom2;

        @ApiModelProperty(value = "基本单位名称")
        private String uom2Name;

        @ApiModelProperty(value = "商品分类")
        private String itemType;

        @ApiModelProperty("单位转换系数")
        private BigDecimal uomRatio;

        @ApiModelProperty("有效位数")
        private Integer decimalPlaces;

        @ApiModelProperty("强配活动ID")
        private Long activityId;

        @ApiModelProperty("强配活动编码")
        private String activityCode;

        @ApiModelProperty("最小强配数量")
        private BigDecimal minNum;

        @ApiModelProperty("分配仓库数量数据")
        private List<ScpDemandOrderDSubmitVO.WhAllocObject> whAllocObjects;
    }

    @Data
    public static class WhAllocObject {

        @ApiModelProperty("数量")
        private BigDecimal qty;

        @ApiModelProperty("含税单价")
        private BigDecimal itemPrice;

        @ApiModelProperty(value = "供应商仓库或供应商id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long supplyWhId;

        @ApiModelProperty(value = "供应商仓库或供应商编码")
        private String supplyWhCode;

        @ApiModelProperty(value = "供应商仓库或供应商名称")
        private String supplyWhName;

        @ApiModelProperty(value = "WH-仓库  SUPP-供应商")
        private String supplyType;

        @ApiModelProperty(value = "仓库/供应商分配比例")
        private BigDecimal ratio;

        @ApiModelProperty("采购公司id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long ouId;

        @ApiModelProperty("采购公司编码")
        private String ouCode;

        @ApiModelProperty("采购公司名称")
        private String ouName;

        @ApiModelProperty("运费是否需要计费")
        private Boolean freightFlag;

        @ApiModelProperty("运费比例")
        private BigDecimal freightRatio;

        @ApiModelProperty("销售公司编码")
        private String saleOuCode;

        @ApiModelProperty("销售公司名称")
        private String saleOuName;

        @ApiModelProperty("销售客户编码")
        private String saleCustCode;

    }


    @ApiModelProperty("spu规格型号")
    private String spec;

    @ApiModelProperty("商品图片")
    private String url;

    @ApiModelProperty("组合商品标识")
    private Boolean combineItemFlag;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    private String combineItemName;
}
