package com.elitesland.scp.application.service.calendar;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetLinePageParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetLineParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLinePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLineRespVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetLineDelVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetLineSaveVO;
import com.elitesland.scp.domain.convert.calendar.ScpStoreCalendarSetLineConvert;
import com.elitesland.scp.domain.entity.calendar.ScpStoreCalendarSetLineDO;
import com.elitesland.scp.domain.service.calendar.ScpStoreCalendarSetLineDomainService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgOuService;
import com.elitesland.scp.rmi.RmiSalRpcService;
import com.elitesland.support.provider.item.dto.ItmBrandRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@RequiredArgsConstructor
@Service
@Slf4j
public class ScpStoreCalendarSetLineServiceImpl implements ScpStoreCalendarSetLineService {
    private final ScpStoreCalendarSetLineDomainService scpStoreCalendarSetLineDomainService;
    private final EntityManager entityManager;
    private final RmiOrgOuService rmiOrgOuService;
    private final RmiItemService rmiItemService;
    private final RmiSalRpcService rmiSalRpcService;

    @Override
    @SysCodeProc
    public PagingVO<ScpStoreCalendarSetLinePageRespVO> page(ScpStoreCalendarSetLinePageParamVO paramVO) {
        PagingVO<ScpStoreCalendarSetLinePageRespVO> page = scpStoreCalendarSetLineDomainService.queryCalendarSetLineList(paramVO);
        List<String> ouCodes = page.getRecords().stream().map(ScpStoreCalendarSetLinePageRespVO::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> brandCodes = page.getRecords().stream().map(ScpStoreCalendarSetLinePageRespVO::getBrandCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> regionCodes = page.getRecords().stream().map(ScpStoreCalendarSetLinePageRespVO::getRegionCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> custCodes = page.getRecords().stream().map(ScpStoreCalendarSetLinePageRespVO::getCustCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuService.findOuDtoMapByOuCodes(ouCodes);
        Map<String, ItmBrandRpcDTO> brandMap = rmiItemService.getBrandMap(brandCodes);
        Map<String, String> regionMap = rmiOrgOuService.findRegionMapByCodes(new HashSet<>(regionCodes));
        Map<String, CustBaseDTO> custBaseMap = rmiSalRpcService.getCustBaseMapByCode(custCodes);
        page.getRecords().forEach(row -> {
            row.setOuName(ouMap.get(row.getOuCode()).getOuName());
            row.setBrandName(brandMap.get(row.getBrandCode()).getBrandName());
            row.setRegionName(regionMap.get(row.getRegionCode()));
            row.setCustName(custBaseMap.get(row.getCustCode()).getCustName());
        });
        return page;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveCalendarSetLine(Long masId, List<ScpStoreCalendarSetLineSaveVO> saveVOS) {
        List<Long> storeIds = saveVOS.stream().map(ScpStoreCalendarSetLineSaveVO::getStoreId).collect(Collectors.toList());
        ScpStoreCalendarSetLineParamVO scpStoreCalendarSetLineParamVO = new ScpStoreCalendarSetLineParamVO();
        scpStoreCalendarSetLineParamVO.setMasId(masId);
        scpStoreCalendarSetLineParamVO.setStoreIds(storeIds);
        scpStoreCalendarSetLineParamVO.setTodayWeek(saveVOS.get(0).getTodayWeek());
        List<ScpStoreCalendarSetLineRespVO> calendarSets = scpStoreCalendarSetLineDomainService.findCalendarSetInfoByParam(scpStoreCalendarSetLineParamVO);
        if (CollUtil.isNotEmpty(calendarSets)) {
            String storeName = calendarSets.get(0).getStoreName();
            throw new BusinessException("门店【" + storeName + "】已存在，请检查");
        }
        List<ScpStoreCalendarSetLineDO> dataList = saveVOS.stream().map(row -> {
            ScpStoreCalendarSetLineDO scpStoreCalendarSetLineDO = ScpStoreCalendarSetLineConvert.INSTANCE.saveVoToDO(row);
            scpStoreCalendarSetLineDO.setMasId(masId);
            return scpStoreCalendarSetLineDO;
        }).collect(Collectors.toList());
        batchInsert(dataList, 1000);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByParam(ScpStoreCalendarSetLineDelVO paramVO) {
        scpStoreCalendarSetLineDomainService.deleteByParam(paramVO);
    }

    public void batchInsert(List<ScpStoreCalendarSetLineDO> dataList, int batchSize) {
        int index = 0;
        for (ScpStoreCalendarSetLineDO data : dataList) {
            entityManager.persist(data);
            if (batchSize > 1) {
                // 开启批量
                index++;
                if (index % batchSize == 0) {
                    entityManager.flush();
                    entityManager.clear();
                }
            }
        }
        if (!dataList.isEmpty()) {
            entityManager.flush();
        }
    }
}
