package com.elitesland.scp.application.service.order;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderTitlePageRespVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;


@Component
@Slf4j
@RequiredArgsConstructor
public class ScpDemandOrderExportServiceImpl implements DataExport<ScpDemandOrderTitlePageRespVO, ScpDemandOrderPageParamVO> {

    private final ScpDemandOrderService scpDemandOrderService;

    @Override
    public String getTmplCode() {
        return "yst_scp_demand_order_export";
    }

    @Override
    public PagingVO<ScpDemandOrderTitlePageRespVO> executeExport(ScpDemandOrderPageParamVO queryParamVO) {
        return scpDemandOrderService.page(queryParamVO);
    }
}
