package com.elitesland.scp.application.web.alloc;


import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingStatusParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingSaveVO;
import com.elitesland.scp.application.service.alloc.ScpAllocSettingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@Api(tags = "订货强配接口")
@RestController
@RequestMapping(value = "/alloc/setting", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpAllocSettingController {

    private final ScpAllocSettingService scpAllocSettingService;

    @ApiOperation(value = "订货强配-  分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpAllocSettingPageRespVO>> queryAllocSetting(@RequestBody ScpAllocSettingPageParamVO paramVO) {
        log.info("[SCP-ALLOC-SETTING] queryAllocSetting  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpAllocSettingService.page(paramVO));
    }

    @ApiOperation("订货强配 - 根据ID查询订货强配活动信息")
    @GetMapping("/findIdOne/{id}")
    public ApiResult<ScpAllocSettingRespVO> findIdOne(@PathVariable Long id) {
        log.info("[SCP-ALLOC-SETTING] findIdOne, id ={}", id);
        return ApiResult.ok(scpAllocSettingService.findAllocSettingById(id));
    }

    @PostMapping("/save")
    @ApiOperation("订货强配 - 保存")
    public ApiResult<Long> saveAllocSetting(@RequestBody @Validated ScpAllocSettingSaveVO saveVO) {
        log.info("[SCP-ALLOC-SETTING] saveAllocSetting  saveVO ={}", JSONUtil.toJsonStr(saveVO));
        return ApiResult.ok(scpAllocSettingService.saveAllocSetting(saveVO));
    }

    @ApiOperation("订货强配 - 启用/禁用")
    @PostMapping("/change")
    public ApiResult<Object> changeStatus(@RequestBody @Validated ScpAllocSettingStatusParamVO paramVO) {
        log.info("[SCP-ALLOC-SETTING] changeStatus paramVO = {}", JSONUtil.toJsonStr(paramVO));
        scpAllocSettingService.changeAllocSettingStatus(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation("订货强配 - 删除")
    @PostMapping("/delete")
    public ApiResult<Object> delete(@RequestBody List<Long> ids) {
        log.info("[SCP-ALLOC-SETTING] delete ids = {}", JSONUtil.toJsonStr(ids));
        scpAllocSettingService.deleteByIds(ids);
        return ApiResult.ok();
    }

}
