package com.elitesland.scp.application.web.devops;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.param.common.TestParamVO;
import com.elitesland.scp.application.service.app.ScpCacheService;
import com.elitesland.scp.utils.SysUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@Slf4j
@Api(tags = "运维接口")
@RestController
@RequestMapping(value = "/devops", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class DevopsController {

    private final ScpCacheService scpCacheService;
    private final RedisTemplate redisTemplate;

    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    @GetMapping("/clearCache")
    @ApiOperation("商品-清除缓存")
    public ApiResult<Map<String, Object>> clearCache() {
        log.info("[SCP-DEVOPS] clearCache  paramVO ={}");
        scpCacheService.deleteAllKeys();
        return ApiResult.ok();
    }

    @PostMapping("/clearCacheByItem")
    @ApiOperation("商品-清除缓存-SPU级别")
    public ApiResult<Object> clearCacheByItem(@RequestBody List<Long> spuIds) {
        log.info("[SCP-DEVOPS] clearCacheByItem  paramVO ={}", JSONUtil.toJsonStr(spuIds));
        scpCacheService.deleteKeys(spuIds);
        return ApiResult.ok();
    }

    @GetMapping("/clear/setting")
    @ApiOperation("系统配置信息-清除缓存")
    public ApiResult<Map<String, Object>> clearSysSetting() {
        log.info("[SCP-DEVOPS] clearSysSetting  paramVO ={}");
        SysUtils.refreshSetting();
        return ApiResult.ok();
    }

    @PostMapping("/test")
    public ApiResult<Map<String, Object>> payNotify() {
        log.info("[SCP-DEVOPS] clearSysSetting  paramVO ={}");
        SysUtils.refreshSetting();
        return ApiResult.ok();
    }


    @PostMapping("/php/verify")
    @ApiOperation("系统配置信息-清除缓存")
    public ApiResult<Map<String, Object>> testVerify(@RequestBody Map<String, Object> paramVO) throws Exception {
        log.info("[SCP-DEVOPS] test  paramVO ={}", JSONUtil.toJsonStr(paramVO));

        // 公钥内容
        var publicKeyStr = "-----BEGIN PUBLIC KEY-----\n" +
                "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqDKHcZ5JY6SuPRJ64rpz\n" +
                "d1LQshIFOzyQu6le+KzHrG4cmlGuwPUy/ZO0nfXsStpEUbh2cLgMrYosq+fI4aht\n" +
                "oGJxC4C2StTbPuo579hdzpI6vehc2Dt7PdTxKTek2qBX+mIMNEJ3q7pi65DI07Su\n" +
                "Qn2l69RRzGFQfKEo8EL7hZc4UDMq5KPlyLF4DThnjrI42mjcyuqNhNS+D4WDQ8ZF\n" +
                "2QuCy6MlHh/SpJNwthB8QPqfkBKnPrYv5/L+0L/DCxah6UK/ogrQNORTk/kh8cb9\n" +
                "aIdvtl3LBJ0oL5VrV/YzftIiCeN4AF8sxVEkRJdFafKBKzMEH2imPPC62hmO4vNU\n" +
                "KwIDAQAB\n" +
                "-----END PUBLIC KEY-----";
        // 待签名内容
        StringJoiner joiner = new StringJoiner("&");
        joiner.add("POS");
        joiner.add("POST");
        joiner.add("/api/pos/itmBrand/queryByCode");
        joiner.add(JSONUtil.toJsonStr(paramVO));
        joiner.add("1723105582870");
        joiner.add("b54tb9DOfCAhbB5DXRZ8");

        var plainText = joiner.toString();
        // 签名
        var signatureText = "TQdr61wfyVTdOAV6RYoiEg6/qkEjLAtXrns2GiShdpVawbFq49T8s23+5jq9yxjqydSz4yKUKMzO4xEhVjNPvIB1LvxHsVHCtHPAuAaTuiorJiPTFXE8XG2TGvR3Psr3aOJTf7jd2X/ziyKctU96xHqnm6eOSbwJx8dxcHwHT+/hsZyGmCqe0j0L34TIwDUJxjtIXHE/3RpqQbTHygFkJSu9rWMo0Pk8fb9LjCWkoTkVWTeRYdKBMZ9/dSfyMLPFaOJFj3lUrA4GNXgE1KptEMwKwS2YorTDwO+FVdhwam5iY8z2c1xVW8ZaWdO1vpq8Fis978p8skd9bXzGlRoYig==";
        // 签名算法
        var signatureAlgorithm = "SHA256withRSA";

        publicKeyStr = publicKeyStr.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").trim();
        byte[] publicKeyBytes = cn.hutool.core.codec.Base64.decode(publicKeyStr.getBytes(StandardCharsets.UTF_8));
        byte[] signatureTextBytes = cn.hutool.core.codec.Base64.decode(signatureText.getBytes(StandardCharsets.UTF_8));

        // 转换公钥
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);

        // 验签
        Signature signature = Signature.getInstance(signatureAlgorithm);
        signature.initVerify(publicKey);
        signature.update(plainText.getBytes(StandardCharsets.UTF_8));

        // 验证签名
        boolean verifyResult = signature.verify(signatureTextBytes);
        System.out.println("验签结果: " + verifyResult);


        return ApiResult.ok();
    }

    @GetMapping("/clearSpecCache")
    @ApiOperation("redis-清除指定缓存")
    public ApiResult<Map<String, Object>> clearSpecCache(String spec) {
        log.info("[SCP-DEVOPS] clearSpecCache  paramVO ={}");
        scpCacheService.deleteSpecKeys(spec);
        return ApiResult.ok();
    }

    @GetMapping("/getKey/{key}")
    @ApiOperation("查询指定的redisKey")
    public ApiResult<Object> getKey(@PathVariable String key) {
        Object o = redisTemplate.opsForValue().get(key);
        log.info("key:{} value:{}", key, JSONUtil.toJsonStr(o));
        return ApiResult.ok(o);
    }
}
