package com.elitesland.scp.application.web.order;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetStatusParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetSelectRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandSetSaveVO;
import com.elitesland.scp.application.service.order.ScpDemandOrderSetService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@Api(tags = "订货集接口")
@RestController
@RequestMapping(value = "/order/set", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpDemandOrderSetController {
    private final ScpDemandOrderSetService scpDemandOrderSetService;

    @ApiOperation(value = "订货集-  分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpDemandSetPageRespVO>> queryDemandSet(@RequestBody ScpDemandSetPageParamVO paramVO) {
        log.info("[SCP-DEMAND-SET] queryDemandSet  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpDemandOrderSetService.queryDemandSetList(paramVO));
    }

    @ApiOperation("订货集 - 查询订货集明细信息")
    @GetMapping("/findIdOne/{id}")
    public ApiResult<ScpDemandSetRespVO> findIdOne(@PathVariable Long id) {
        log.info("[SCP-DEMAND-SET] findIdOne, id ={}", id);
        return scpDemandOrderSetService.findDemandSetById(id).map(ApiResult::ok)
                .orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }

    @PostMapping("/save")
    @ApiOperation("订货集 - 保存")
    public ApiResult<Long> saveDemandSet(@RequestBody @Validated ScpDemandSetSaveVO saveVO) {
        log.info("[SCP-DEMAND-SET] saveDemandSet  saveVO ={}", JSONUtil.toJsonStr(saveVO));
        return ApiResult.ok(scpDemandOrderSetService.saveDemandSet(saveVO));
    }

    @ApiOperation("订货集 - 启用/禁用")
    @PostMapping("/change")
    public ApiResult<Object> changeStatus(@RequestBody @Validated ScpDemandSetStatusParamVO paramVO) {
        log.info("[SCP-DEMAND-SET] changeStatus paramVO = {}", JSONUtil.toJsonStr(paramVO));
        scpDemandOrderSetService.changeDemandSetStatus(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation("订货集 - 删除")
    @PostMapping("/delete")
    public ApiResult<Object> delete(@RequestBody List<Long> ids) {
        log.info("[SCP-DEMAND-SET] delete ids = {}", JSONUtil.toJsonStr(ids));
        scpDemandOrderSetService.deleteByIds(ids);
        return ApiResult.ok();
    }

    @ApiOperation("订货集 - 计算分配")
    @PostMapping("/compute")
    public ApiResult<Object> compute(@RequestBody List<Long> ids) {
        log.info("[SCP-DEMAND-SET] compute ids = {}", JSONUtil.toJsonStr(ids));
        scpDemandOrderSetService.compute(ids);
        return ApiResult.ok();
    }

    @ApiOperation(value = "订货集 - 下拉组件")
    @PostMapping(value = "/list")
    public ApiResult<List<ScpDemandSetSelectRespVO>> demandSetSearch(@RequestBody ScpDemandSetParamVO paramVO) {
        log.info("[SCP-DEMAND-SET] demandSetSearch  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpDemandOrderSetService.demandSetSelectList(paramVO));
    }

    @ApiOperation("订货集 - 推送")
    @PostMapping("/push")
    public ApiResult<Object> push(@RequestBody List<Long> ids) {
        log.info("[SCP-DEMAND-SET] push ids = {}", JSONUtil.toJsonStr(ids));
        scpDemandOrderSetService.push(ids);
        return ApiResult.ok();
    }

    @ApiOperation(value = "订货集-  分页公共查询")
    @PostMapping(value = "/common/page")
    public ApiResult<PagingVO<ScpDemandSetPageRespVO>> commonPage(@RequestBody ScpDemandSetPageParamVO paramVO) {
        log.info("[SCP-DEMAND-SET] commonPage  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpDemandOrderSetService.commonPage(paramVO));
    }

    @ApiOperation(value = "订货集-小程序匹配查询")
    @PostMapping(value = "/common/new/list")
    public ApiResult<List<ScpDemandSetPageRespVO>> commonNewList(@RequestBody ScpDemandSetPageParamVO paramVO) {
        log.info("[SCP-DEMAND-SET] commonPage  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpDemandOrderSetService.commonNewPage(paramVO));
    }

}
