package com.elitesland.scp.lakalapay.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel("在线支付入参")
public class OnlineLklPayOrderParamVO implements Serializable {
    private static final long serialVersionUID = 6074350548106028859L;

    @ApiModelProperty(value = "支付单据ID", required = true)
    @NotNull(message = "支付单据ID不能为空")
    private Long docId;

    @ApiModelProperty(value = "支付单据编号", required = true)
    @NotBlank(message = "支付单据编号不能为空")
    private String docNo;

    @ApiModelProperty(value = "支付金额", required = true)
    @NotNull(message = "支付金额不能为空")
    private BigDecimal amt;

    @ApiModelProperty(value = "门店编码", required = true)
    @NotBlank(message = "门店编码不能为空")
    private String storeCode;

    @ApiModelProperty(value = "门店名称", required = true)
    @NotBlank(message = "门店名称不能为空")
    private String storeName;

    @ApiModelProperty(value = "公司id", required = true)
    @NotNull(message = "公司id不能为空")
    private Long ouId;

    @ApiModelProperty("订单附加信息，备注")
    private String remark;

    private String clientIp;

    @ApiModelProperty("付款人账号")
    private String payerNo;

    @ApiModelProperty("付款人名称")
    private String payerName;

    @ApiModelProperty("付款类型")
    private String payerType;

    @ApiModelProperty("收款方信息")
    private List<PayeeInfoVO> payeeInfo;

    @Data
    public static class PayeeInfoVO {
        @ApiModelProperty("收款方名称")
        private String payeeName;

        @ApiModelProperty(value = "收款方账号", required = true)
//        @NotBlank(message = "收款方账号不能为空")
        private String payeeAccountNo;

        @ApiModelProperty(value = "子单商户交易单号", required = true)
//        @NotBlank(message = "子单商户交易单号不能为空")
        private String subOutTradeNo;

        @ApiModelProperty(value = "子交易金额", required = true)
//        @NotBlank(message = "子交易金额不能为空")
        private String subTradeAmount;

//        @ApiModelProperty("商品名称")
//        private String body;
//
//        @ApiModelProperty("冻结标识 (Y-冻结 N-不冻结)")
//        private String payeeFreezeFlag;
    }


}
