package com.elitesland.scp.mq;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.infr.repo.supalloc.ScpSupplyAllocationRepoProc;
import com.elitesland.scp.infr.repo.template.ScpDemandOrderTemplateRepoProc;
import com.elitesland.scp.infr.repo.whnet.ScpWhNetRelationRepoProc;
import com.elitesland.support.provider.out.OrgStoreUpdateMqParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * 门店收货单发货回写
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class OrgStoreUpdateListener implements MessageQueueListener<OrgStoreUpdateMqParam> {

    private final ScpWhNetRelationRepoProc scpWhNetRelationRepoProc;
    private final ScpSupplyAllocationRepoProc scpSupplyAllocationRepoProc;
    private final ScpDemandOrderTemplateRepoProc scpDemandOrderTemplateRepoProc;

    @Override
    public @NotEmpty String[] channels() {
        return new String[]{OrgStoreUpdateMqParam.ORG_STORE_UPDATE_CHANNEL};
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void onConsume(@NotBlank String s, @NotNull OrgStoreUpdateMqParam orgStoreUpdateMqParam) {
        log.info("门店变更：" + JSON.toJSONString(orgStoreUpdateMqParam));
        Long storeId = orgStoreUpdateMqParam.getStoreId();
        String storeName = orgStoreUpdateMqParam.getStoreName();
        scpWhNetRelationRepoProc.updateStoreNameByStoreId(storeId, storeName);
        scpSupplyAllocationRepoProc.updateStoreNameByStoreId(storeId, storeName);
        scpDemandOrderTemplateRepoProc.updateStoreNameByStoreId(storeId, storeName);
    }

}
