package com.elitesland.scp.pay.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel("在线支付入参")
public class OnlinePayOrderParamVO implements Serializable {
    private static final long serialVersionUID = 6074350548106028859L;

    @ApiModelProperty(value = "支付单据ID", required = true)
    @NotNull(message = "支付单据ID不能为空")
    private Long docId;

    @ApiModelProperty(value = "支付单据编号", required = true)
    @NotBlank(message = "支付单据编号不能为空")
    private String docNo;

    @ApiModelProperty(value = "支付金额", required = true)
    @NotNull(message = "支付金额不能为空")
    private BigDecimal amt;

    @ApiModelProperty(value = "门店编码", required = true)
    @NotBlank(message = "门店编码不能为空")
    private String storeCode;

    @ApiModelProperty(value = "门店名称", required = true)
    @NotBlank(message = "门店名称不能为空")
    private String storeName;

    @ApiModelProperty("订单附加信息，备注")
    private String remark;

    @ApiModelProperty(value = "支付来源，小程序：mp，浏览器：browser", required = true)
    @NotBlank(message = "支付来源不能为空")
    private String payerUa;

    @ApiModelProperty(value = "收款商户Id", required = true)
    @NotBlank(message = "收款商户Id不能为空")
    private String entId;

    @ApiModelProperty(value = "收款商户名称", required = true)
    @NotBlank(message = "收款商户名称不能为空")
    private String entName;

    @ApiModelProperty(value = "小程序回调地址")
    private String mpPath;

    private String clientIp;

    @ApiModelProperty("付款人名称")
    private String payerName;

    @ApiModelProperty("付款类型")
    private String payerType;

    @ApiModelProperty(value = "收款商户子账号Id")
    private String entAccId;

}
